/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.widget.SeekBar;

public class VerticalSeekBar
extends SeekBar {
    private boolean mIsDragging;
    private float mTouchDownY;
    private int mScaledTouchSlop;
    private boolean isInScrollingContainer = false;
    private OnSeekBarChangeListener mOnSeekBarChangeListener;
    float mTouchProgressOffset;

    public void setOnSeekBarChangeListener(OnSeekBarChangeListener l) {
        this.mOnSeekBarChangeListener = l;
    }

    public boolean isInScrollingContainer() {
        return this.isInScrollingContainer;
    }

    public void setInScrollingContainer(boolean isInScrollingContainer) {
        this.isInScrollingContainer = isInScrollingContainer;
    }

    public VerticalSeekBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mScaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    public VerticalSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VerticalSeekBar(Context context) {
        super(context);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(h, w, oldh, oldw);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(heightMeasureSpec, widthMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
    }

    protected synchronized void onDraw(Canvas canvas) {
        canvas.rotate(-90.0f);
        canvas.translate((float)(-this.getHeight()), 0.0f);
        super.onDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                if (this.isInScrollingContainer()) {
                    this.mTouchDownY = event.getY();
                    break;
                }
                this.setPressed(true);
                this.invalidate();
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                break;
            }
            case 2: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                } else {
                    float y = event.getY();
                    if (Math.abs(y - this.mTouchDownY) > (float)this.mScaledTouchSlop) {
                        this.setPressed(true);
                        this.invalidate();
                        this.onStartTrackingTouch();
                        this.trackTouchEvent(event);
                        this.attemptClaimDrag();
                    }
                }
                this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                } else {
                    this.onStartTrackingTouch();
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                }
                this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                this.invalidate();
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                }
                this.invalidate();
                break;
            }
        }
        return true;
    }

    private void trackTouchEvent(MotionEvent event) {
        float scale;
        int height = this.getHeight();
        int top = this.getPaddingLeft();
        int bottom = this.getPaddingRight();
        int available = height - top - bottom;
        int y = (int)event.getY();
        float progress = 0.0f;
        if (y > height - bottom) {
            scale = 0.0f;
        } else if (y < top) {
            scale = 1.0f;
        } else {
            scale = 1.0f - (float)y / (float)available;
            progress = this.mTouchProgressOffset;
        }
        int max = this.getMax();
        this.setProgress((int)(progress += scale * (float)max));
    }

    public void onStartTrackingTouch() {
        this.mIsDragging = true;
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onStartTrackingTouch(this);
        }
    }

    public void onStopTrackingTouch() {
        this.mIsDragging = false;
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onStopTrackingTouch(this);
        }
    }

    private void attemptClaimDrag() {
        ViewParent p = this.getParent();
        if (p != null) {
            p.requestDisallowInterceptTouchEvent(true);
        }
    }

    public synchronized void setProgress(int progress) {
        super.setProgress(progress);
        this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onProgressChanged(this, this.getProgress(), this.isPressed());
        }
    }

    public static interface OnSeekBarChangeListener {
        public void onProgressChanged(VerticalSeekBar var1, int var2, boolean var3);

        public void onStartTrackingTouch(VerticalSeekBar var1);

        public void onStopTrackingTouch(VerticalSeekBar var1);
    }
}

