/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.statistic;

import android.os.Build;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.DefaultRequestParam;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.statistic.AbstractReportProperty;
import com.yy.mobile.statistic.StatisticDataContainerInterface;
import com.yy.mobile.statistic.StatisticDataModelBase;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatisticDataContainer
implements StatisticDataContainerInterface {
    private static final String TAG = "StatisticDataContainer";
    private static StatisticDataContainer mInstance = null;
    private final GsonBuilder mGsonBuilder = new GsonBuilder();
    private Map<String, List<StatisticDataModelBase>> dataMap;

    public static synchronized StatisticDataContainer instance() {
        if (mInstance == null) {
            mInstance = new StatisticDataContainer();
        }
        return mInstance;
    }

    private StatisticDataContainer() {
        this.mGsonBuilder.serializeNulls().excludeFieldsWithoutExposeAnnotation();
        this.dataMap = new ConcurrentHashMap<String, List<StatisticDataModelBase>>();
    }

    @Override
    public String getAsJson(Object context, AbstractReportProperty reportProperty) {
        if (context == null || FP.empty(this.dataMap)) {
            return null;
        }
        try {
            Gson gson = this.mGsonBuilder.create();
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<String, List<StatisticDataModelBase>> m : this.dataMap.entrySet()) {
                ArrayList<StatisticDataModelBase> list = new ArrayList<StatisticDataModelBase>();
                for (StatisticDataModelBase item : m.getValue()) {
                    if (item.isReporting) continue;
                    item.reportContext = context;
                    item.isReporting = true;
                    list.add(item);
                }
                if (list.size() <= 0) continue;
                jsonObject.add(m.getKey(), gson.toJsonTree(list));
            }
            if (gson.toJson((JsonElement)jsonObject).equals("{}")) {
                return null;
            }
            jsonObject.addProperty("app_ver", VersionUtil.getLocalVer(BasicConfig.getInstance().getAppContext()).toString());
            jsonObject.addProperty("platform", "android");
            jsonObject.addProperty("os_ver", "Android" + Build.VERSION.RELEASE);
            jsonObject.addProperty("hardware", Build.MANUFACTURER + "_" + Build.MODEL);
            jsonObject.addProperty("network", (Number)NetworkUtils.getNetworkType(BasicConfig.getInstance().getAppContext()));
            if (reportProperty != null) {
                jsonObject.addProperty("uid", (Number)reportProperty.getUid());
            } else {
                MLog.error((Object)TAG, "statistic get json data error! can not get uid!", new Object[0]);
            }
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, gson.toJson((JsonElement)jsonObject), new Object[0]);
            }
            return gson.toJson((JsonElement)jsonObject);
        }
        catch (Exception e) {
            MLog.error(TAG, e);
            return null;
        }
    }

    @Override
    public void submitRequest(final Object context, String url, String jsonData) {
        DefaultRequestParam param = new DefaultRequestParam();
        param.put("yy_mobile_stat", jsonData);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "postData, yy_mobile_stat : " + jsonData, new Object[0]);
        }
        RequestManager.instance().submitMultipartPostRequest(url, (RequestParam)param, new ResponseListener<String>(){

            @Override
            public void onResponse(String response) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(StatisticDataContainer.TAG, "postData succeed! " + response, new Object[0]);
                }
                StatisticDataContainer.this.onReportSuc(context);
            }
        }, new ResponseErrorListener(){

            @Override
            public void onErrorResponse(RequestError error) {
                MLog.error((Object)StatisticDataContainer.TAG, "postData failed! " + error.toString(), new Object[0]);
                StatisticDataContainer.this.onReportFail(context);
            }
        }, true);
    }

    @Override
    public void addData(StatisticDataModelBase dataModelBase) {
        if (dataModelBase == null || dataModelBase.getActionName() == null) {
            return;
        }
        String action = dataModelBase.getActionName();
        if (!this.dataMap.containsKey(action)) {
            this.dataMap.put(action, new ArrayList());
        }
        if (this.dataMap.get(action) == null) {
            this.dataMap.put(action, new ArrayList());
        }
        List<StatisticDataModelBase> list = this.dataMap.get(action);
        list.add(dataModelBase);
    }

    @Override
    public void onReportSuc(Object context) {
        for (Map.Entry<String, List<StatisticDataModelBase>> m : this.dataMap.entrySet()) {
            Iterator<StatisticDataModelBase> iterator = m.getValue().iterator();
            while (iterator.hasNext()) {
                StatisticDataModelBase item = iterator.next();
                if (item.reportContext != context) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public void onReportFail(Object context) {
        for (Map.Entry<String, List<StatisticDataModelBase>> m : this.dataMap.entrySet()) {
            for (StatisticDataModelBase item : m.getValue()) {
                if (item.reportContext != context) continue;
                item.isReporting = false;
            }
        }
    }

    @Override
    public void clear() {
        this.dataMap.clear();
    }
}

