/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http.httpsparser;

import android.support.annotation.NonNull;
import java.net.URI;
import java.util.Map;

public class HttpsParser {
    private static Map<String, Integer> mHostMap;
    private static final String FORCE = "force";
    private static final String HTTP = "http:";
    private static final String HTTPS = "https:";
    private static int mForce;

    public static String getHost(String url) {
        if (url == null || !url.startsWith("http")) {
            return null;
        }
        try {
            URI uri = new URI(url);
            return uri.getHost() == null ? url : uri.getHost();
        }
        catch (Throwable throwable) {
            return url;
        }
    }

    public static boolean needsConvert(@NonNull String host) {
        Map<String, Integer> tmpMap = mHostMap;
        if (tmpMap == null || tmpMap.size() <= 0) {
            return false;
        }
        for (String key : tmpMap.keySet()) {
            if (host.indexOf(key) == -1) continue;
            return tmpMap.get(key) == 1;
        }
        return mForce == 1;
    }

    public static String convertToHttps(String url) {
        if (url == null || url.isEmpty() || !url.startsWith(HTTP)) {
            return url;
        }
        String host = HttpsParser.getHost(url);
        if (host == null || host.isEmpty() || host.startsWith(HTTPS)) {
            return url;
        }
        if (HttpsParser.needsConvert(host)) {
            return url.replaceFirst(HTTP, HTTPS);
        }
        return url;
    }

    public static String convertToHttp(String url) {
        if (url == null || url.isEmpty() || !url.startsWith(HTTPS)) {
            return url;
        }
        String host = HttpsParser.getHost(url);
        if (host == null || host.isEmpty() || host.startsWith(HTTP)) {
            return url;
        }
        if (HttpsParser.needsConvert(host)) {
            return url.replaceFirst(HTTPS, HTTP);
        }
        return url;
    }

    public static void setHostMap(@NonNull Map<String, Integer> hostMap) {
        mHostMap = hostMap;
    }

    public static void setForce(int force) {
        mForce = force;
    }

    static {
        mForce = 0;
    }
}

