/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.mobile.http.BaseRequest;
import com.yy.mobile.http.DefaultRequestParam;
import com.yy.mobile.http.DefaultRetryPolicy;
import com.yy.mobile.http.HttpHeaderParser;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.NoCache;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.Response;
import com.yy.mobile.http.ResponseData;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.http.RetryPolicy;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.io.UnsupportedEncodingException;

public class AbstractUploadRequest<String>
extends BaseRequest {
    public static final int TIMEOUT_MS = 6000;
    public static final int MAX_RETRIES = 3;
    public static final float BACKOFF_MULT = 0.4f;
    public static final String THRESHOLD_TYPE = "UploadTraffic";
    protected ProgressListener mProgressListener;
    protected RequestParam mRequestParam;

    public AbstractUploadRequest(String url, RequestParam param, ResponseListener<String> successListener, ResponseErrorListener errorListener) {
        this(url, param, successListener, errorListener, null);
    }

    public AbstractUploadRequest(String url, RequestParam param, ResponseListener<String> successListener, ResponseErrorListener errorListener, ProgressListener progressListener) {
        super(new NoCache(), url, successListener, errorListener);
        this.mMethod = 1;
        this.mProgressListener = progressListener;
        if (this.mRequestParam == null) {
            this.mRequestParam = new DefaultRequestParam();
        }
        this.mRequestParam = param;
        this.setShouldCache(false);
        this.setRetryPolicy(new DefaultRetryPolicy(6000, 3, 0.4f));
    }

    public AbstractUploadRequest(String url, RequestParam param, ResponseListener<String> successListener, ResponseErrorListener errorListener, ProgressListener progressListener, RetryPolicy retryPolicy) {
        super(new NoCache(), url, successListener, errorListener);
        this.mMethod = 1;
        this.mProgressListener = progressListener;
        if (this.mRequestParam == null) {
            this.mRequestParam = new DefaultRequestParam();
        }
        this.mRequestParam = param;
        this.setShouldCache(false);
        this.setRetryPolicy(retryPolicy);
    }

    @Override
    public void parseDataToResponse(ResponseData responseData) {
        String parsed;
        HttpLog.v(this.getClass().getName() + " parse network response url=" + this.mUrl, new Object[0]);
        try {
            parsed = new String(responseData.data, HttpHeaderParser.parseCharset(responseData.headers));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(responseData.data);
        }
        this.mResponse = Response.success(parsed, HttpHeaderParser.parseCacheHeaders(responseData, this.mCacheController, this));
    }

    public void pushProgress(long progress, long total) {
        YYTaskExecutor.postToMainThread(new BaseRequest.ProgressDeliveryRunnable(this, this, this.mProgressListener, new ProgressInfo(progress, total)));
    }

    @Override
    public int getThreshold() {
        return 1;
    }

    @Override
    public String getThresholdType() {
        return THRESHOLD_TYPE;
    }
}

