/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.cache;

import com.yy.mobile.cache.CacheClient;
import com.yy.mobile.util.valid.BlankUtil;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheClientFactory {
    private static final String publicUri = "dataCache" + File.separator + "public" + File.separator;
    private static final String privateUri = "dataCache" + File.separator + "private" + File.separator;
    private static Map<CacheType, CacheClient> map = new ConcurrentHashMap<CacheType, CacheClient>();

    public static CacheClient getPublic() {
        CacheClient client = map.get((Object)CacheType.PUBLIC);
        if (BlankUtil.isBlank(client)) {
            String uri = publicUri;
            client = new CacheClient(uri);
            map.put(CacheType.PUBLIC, client);
        }
        return client;
    }

    public static CacheClient getPrivate() {
        CacheClient client = map.get((Object)CacheType.PRIVATE);
        return client;
    }

    public static void removePrivate() {
        map.remove((Object)CacheType.PRIVATE);
    }

    public static void registerPrivate(String uri) {
        uri = privateUri + uri;
        CacheClient client = new CacheClient(uri);
        map.put(CacheType.PRIVATE, client);
    }

    public static enum CacheType {
        PRIVATE,
        PUBLIC;

    }
}

