/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.javascript;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.yy.mobile.util.javascript.ResultData;
import com.yy.mobile.util.javascript.apiModule.ApiModuleManager;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.javascript.apiModule.INewJSCallback;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import java.lang.ref.WeakReference;

public class JavaScriptInterface {
    private static final String TAG = "JavaScriptInterface";
    private WeakReference<WebView> webViewHolder = null;
    public static final String INVOKE_WEB_METHOD = "javascript:try{window.YYApiCore.invokeWebMethod('%s',JSON.parse(%s))}catch(e){if(console)console.log(e)}";
    public static final String INVOKE_WEB_METHOD_WITHOUT_JSON_PARSE = "javascript:try{window.YYApiCore.invokeWebMethod('%s',%s)}catch(e){if(console)console.log(e)}";
    private ApiModuleManager v2ApiModuleManager = new ApiModuleManager();
    private Handler mtHandler = new Handler(Looper.getMainLooper());

    public JavaScriptInterface(WebView view) {
        if (view != null) {
            this.webViewHolder = new WeakReference<WebView>(view);
        }
    }

    public void addApiModule(IApiModule module) {
        this.v2ApiModuleManager.addModule(module);
    }

    public void removeApiModule(String moduleName) {
        this.v2ApiModuleManager.removeModuleByName(moduleName);
    }

    @TargetApi(value=11)
    public void release() {
        WebView webView;
        if (this.webViewHolder != null && (webView = (WebView)this.webViewHolder.get()) != null && Build.VERSION.SDK_INT > 11) {
            webView.removeJavascriptInterface("AndroidJSInterfaceV2");
        }
        if (this.v2ApiModuleManager != null) {
            this.v2ApiModuleManager.release();
        }
    }

    @JavascriptInterface
    public String invoke(String module, String name, String parameters, String callback) {
        try {
            IApiModule apiModule = this.v2ApiModuleManager.getModule(module);
            if (apiModule != null) {
                String result = apiModule.invoke(name, parameters, this.genJSCallback(callback));
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(TAG, "module %s name %s params %s callback %s result %s", module, name, parameters, callback, result);
                }
                if ("".equals(result) || result == null) {
                    result = "{}";
                }
                return result;
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "invoke module = " + module + ", name = " + name + ", parameters = " + parameters + ", error happen e = " + e, e, new Object[0]);
        }
        return JsonParser.toJson(new ResultData(-1));
    }

    private void invokeJSCallback(final String cbName, final String jsonParam) {
        this.mtHandler.post(new Runnable(){

            @Override
            public void run() {
                WebView webView;
                if (JavaScriptInterface.this.webViewHolder != null && (webView = (WebView)JavaScriptInterface.this.webViewHolder.get()) != null) {
                    try {
                        String invokeStr = String.format(JavaScriptInterface.INVOKE_WEB_METHOD, cbName, jsonParam);
                        if (!MLog.isLogLevelAboveVerbose()) {
                            MLog.verbose(JavaScriptInterface.TAG, invokeStr, new Object[0]);
                        }
                        webView.loadUrl(invokeStr);
                    }
                    catch (Exception e) {
                        MLog.error(JavaScriptInterface.TAG, e);
                    }
                }
            }
        });
    }

    private void invokeJSCallbackWithOutJsonParse(final String cbName, final String jsonParam) {
        this.mtHandler.post(new Runnable(){

            @Override
            public void run() {
                WebView webView;
                if (JavaScriptInterface.this.webViewHolder != null && (webView = (WebView)JavaScriptInterface.this.webViewHolder.get()) != null) {
                    try {
                        String invokeStr = String.format(JavaScriptInterface.INVOKE_WEB_METHOD_WITHOUT_JSON_PARSE, cbName, jsonParam);
                        if (!MLog.isLogLevelAboveVerbose()) {
                            MLog.verbose(JavaScriptInterface.TAG, invokeStr, new Object[0]);
                        }
                        if (Build.VERSION.SDK_INT <= 18) {
                            webView.loadUrl(invokeStr);
                        } else {
                            try {
                                webView.evaluateJavascript(invokeStr, null);
                            }
                            catch (Exception e) {
                                MLog.error(this, e);
                                MLog.info(this, "switch to call loadUrl", new Object[0]);
                                webView.loadUrl(invokeStr);
                            }
                        }
                    }
                    catch (Exception e) {
                        MLog.error(JavaScriptInterface.TAG, e);
                    }
                }
            }
        });
    }

    private IApiModule.IJSCallback genJSCallback(final String callbackName) {
        if (callbackName != null && callbackName.length() > 0) {
            return new INewJSCallback(){

                @Override
                public void invokeCallback(String param) {
                    JavaScriptInterface.this.invokeJSCallback(callbackName, param);
                }

                @Override
                public void invokeCallbackWithoutJsonParse(String param) {
                    JavaScriptInterface.this.invokeJSCallbackWithOutJsonParse(callbackName, param);
                }
            };
        }
        return null;
    }
}

