/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.datetimepicker;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import com.yy.mobile.ui.widget.datetimepicker.DatePickerController;
import com.yy.mobile.ui.widget.datetimepicker.SimpleMonthView;
import java.util.Calendar;
import java.util.HashMap;

public class SimpleMonthAdapter
extends BaseAdapter
implements SimpleMonthView.OnDayClickListener {
    protected static int WEEK_7_OVERHANG_HEIGHT = 7;
    protected static final int MONTHS_IN_YEAR = 12;
    private final Context mContext;
    private final DatePickerController mController;
    private CalendarDay mSelectedDay;

    public SimpleMonthAdapter(Context context, DatePickerController datePickerController) {
        this.mContext = context;
        this.mController = datePickerController;
        this.init();
        this.setSelectedDay(this.mController.getSelectedDay());
    }

    private boolean isSelectedDayInMonth(int year, int month) {
        return this.mSelectedDay.year == year && this.mSelectedDay.month == month;
    }

    public int getCount() {
        return (this.mController.getMaxYear() - this.mController.getMinYear() + 1) * 12;
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        SimpleMonthView v;
        HashMap<String, Integer> drawingParams = null;
        if (convertView != null) {
            v = (SimpleMonthView)convertView;
            drawingParams = (HashMap<String, Integer>)v.getTag();
        } else {
            v = new SimpleMonthView(this.mContext);
            v.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
            v.setClickable(true);
            v.setOnDayClickListener(this);
        }
        if (drawingParams == null) {
            drawingParams = new HashMap<String, Integer>();
        }
        drawingParams.clear();
        int month = position % 12;
        int year = position / 12 + this.mController.getMinYear();
        int selectedDay = -1;
        if (this.isSelectedDayInMonth(year, month)) {
            selectedDay = this.mSelectedDay.day;
        }
        v.reuse();
        drawingParams.put("selected_day", selectedDay);
        drawingParams.put("year", year);
        drawingParams.put("month", month);
        drawingParams.put("week_start", this.mController.getFirstDayOfWeek());
        v.setMonthParams(drawingParams);
        v.invalidate();
        return v;
    }

    protected void init() {
        this.mSelectedDay = new CalendarDay(System.currentTimeMillis());
    }

    @Override
    public void onDayClick(SimpleMonthView simpleMonthView, CalendarDay calendarDay) {
        if (calendarDay != null) {
            this.onDayTapped(calendarDay);
        }
    }

    protected void onDayTapped(CalendarDay calendarDay) {
        this.mController.tryVibrate();
        this.mController.onDayOfMonthSelected(calendarDay.year, calendarDay.month, calendarDay.day);
        this.setSelectedDay(calendarDay);
    }

    public void setSelectedDay(CalendarDay calendarDay) {
        this.mSelectedDay = calendarDay;
        this.notifyDataSetChanged();
    }

    public static class CalendarDay {
        private Calendar calendar;
        int day;
        int month;
        int year;

        public CalendarDay() {
            this.setTime(System.currentTimeMillis());
        }

        public CalendarDay(int year, int month, int day) {
            this.setDay(year, month, day);
        }

        public CalendarDay(long timeInMillis) {
            this.setTime(timeInMillis);
        }

        public CalendarDay(Calendar calendar) {
            this.year = calendar.get(1);
            this.month = calendar.get(2);
            this.day = calendar.get(5);
        }

        private void setTime(long timeInMillis) {
            if (this.calendar == null) {
                this.calendar = Calendar.getInstance();
            }
            this.calendar.setTimeInMillis(timeInMillis);
            this.month = this.calendar.get(2);
            this.year = this.calendar.get(1);
            this.day = this.calendar.get(5);
        }

        public void set(CalendarDay calendarDay) {
            this.year = calendarDay.year;
            this.month = calendarDay.month;
            this.day = calendarDay.day;
        }

        public void setDay(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }
    }
}

