/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.bubblelayout;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.PopupWindow;

public class BubblePopupWindow
extends PopupWindow {
    private Context context;

    public BubblePopupWindow(Context context) {
        this.context = context;
        this.setWidth(-2);
        this.setHeight(-2);
        this.setFocusable(true);
        this.setOutsideTouchable(false);
        this.setClippingEnabled(false);
        ColorDrawable dw = new ColorDrawable(0);
        this.setBackgroundDrawable((Drawable)dw);
    }

    public void setBubbleView(View view) {
        this.setContentView(view);
    }

    public void setParam(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void show(View parent) {
        this.show(parent, 48);
    }

    public void show(View parent, int gravity) {
        if (!this.isShowing()) {
            int[] location = new int[2];
            parent.getLocationOnScreen(location);
            switch (gravity) {
                case 80: {
                    this.showAsDropDown(parent);
                    break;
                }
                case 48: {
                    this.showAtLocation(parent, 0, location[0] + parent.getWidth() / 2 - this.getMeasuredWidth() / 2, location[1] - this.getMeasureHeight());
                    break;
                }
                case 5: {
                    this.showAtLocation(parent, 0, location[0] + parent.getWidth(), location[1] - parent.getHeight() / 2);
                    break;
                }
                case 3: {
                    this.showAtLocation(parent, 0, location[0] - this.getMeasuredWidth(), location[1] - parent.getHeight() / 2);
                    break;
                }
            }
        } else {
            this.dismiss();
        }
    }

    public int getMeasureHeight() {
        int popHeight = 0;
        View contentView = this.getContentView();
        if (this.getContentView() != null) {
            contentView.measure(0, 0);
            popHeight = contentView.getMeasuredHeight();
        }
        return popHeight;
    }

    public int getMeasuredWidth() {
        int popWidth = 0;
        View contentView = this.getContentView();
        if (contentView != null) {
            contentView.measure(0, 0);
            popWidth = contentView.getMeasuredWidth();
        }
        return popWidth;
    }
}

