/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.CompoundButton;
import java.util.ArrayList;

public class ViewContainer {
    private Activity mActivity;
    LayoutInflater mFactory;
    private View mView;
    ViewGroup mViewRoot;
    private boolean mIsShow;
    Object mRoot;
    ArrayList<ViewContainer> mChildren = new ArrayList();
    ViewContainer mParent = null;

    public ViewContainer(Activity c) {
        this.mActivity = c;
        this.mFactory = LayoutInflater.from((Context)this.mActivity);
        this.mRoot = c;
    }

    public ViewContainer(Activity c, int resId) {
        this(c, resId, null);
    }

    public ViewContainer(Activity context, int resId, ViewGroup root) {
        this(context);
        this.mViewRoot = root;
        this.inflater(resId, root);
    }

    public ViewContainer(Activity context, View v) {
        this.mActivity = context;
        this.mView = v;
    }

    public void removeFromParent() {
        if (this.mParent == null) {
            return;
        }
        this.mParent.mChildren.remove(this);
    }

    public View inflater(int resId) {
        return this.inflater(resId, this.mViewRoot);
    }

    public View inflater(int resId, ViewGroup root) {
        this.mView = this.mFactory.inflate(resId, null);
        if (this.mView == null) {
            throw new RuntimeException();
        }
        if (root != null) {
            root.addView(this.mView);
        }
        return this.mView;
    }

    public final View findViewById(int id2) {
        return this.mView.findViewById(id2);
    }

    public final View findViewWithTag(String tag) {
        return this.mView.findViewWithTag((Object)tag);
    }

    public Context getContext() {
        return this.mActivity;
    }

    public Activity getAct() {
        return this.getUIAct();
    }

    public Activity getUIAct() {
        if (this.mActivity instanceof Activity) {
            return this.mActivity;
        }
        return null;
    }

    public Object getRoot() {
        return this.mRoot;
    }

    public ViewContainer getParent() {
        return this.mParent;
    }

    public View getView() {
        return this.mView;
    }

    public void setView(View v) {
        this.mView = v;
    }

    public Drawable getDrawable(int id2) {
        return this.mActivity.getResources().getDrawable(id2);
    }

    public String getString(int id2) {
        return this.mActivity.getString(id2);
    }

    public String getString(int id2, Object ... formatArgs) {
        return this.mActivity.getString(id2, formatArgs);
    }

    public void onResume() {
        this.mIsShow = true;
        for (ViewContainer v : this.mChildren) {
            v.onResume();
        }
    }

    public void onPause() {
        this.mIsShow = false;
        for (ViewContainer v : this.mChildren) {
            v.onPause();
        }
    }

    public boolean isActive() {
        return this.mIsShow;
    }

    public void setOnClickListener(int id2, View.OnClickListener l) {
        this.mView.findViewById(id2).setOnClickListener(l);
    }

    public void setOnKeyListener(int id2, View.OnKeyListener l) {
        this.mView.findViewById(id2).setOnKeyListener(l);
    }

    public void setOnCheckedChangeListener(int id2, CompoundButton.OnCheckedChangeListener l) {
        ((CompoundButton)this.mView.findViewById(id2)).setOnCheckedChangeListener(l);
    }

    public void setOnItemClickListener(AdapterView<?> v, AdapterView.OnItemClickListener l) {
        v.setOnItemClickListener(l);
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
    }

    public boolean onContextItemSelected(MenuItem item) {
        return false;
    }

    public boolean onBackPressed() {
        return false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public abstract class RunOnUI
    implements Runnable {
        public RunOnUI() {
            ViewContainer.this.mActivity.runOnUiThread((Runnable)this);
        }
    }
}

