/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.imageloader;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.FutureTarget;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.framework.R;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.http.httpsparser.HttpsParser;
import com.yy.mobile.image.ImageCache;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.BigPicRecycler;
import com.yy.mobile.imageloader.GifHandler;
import com.yy.mobile.imageloader.IRecycler;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.imageloader.customcache.YYLruBitmapPool;
import com.yy.mobile.imageloader.customcache.YYLruResourceCache;
import com.yy.mobile.imageloader.transform.GlideCircleTransform;
import com.yy.mobile.imageloader.transform.GlideRoundTransform;
import com.yy.mobile.imageloader.transform.YYBitmapTransformation;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.io.File;
import java.lang.ref.WeakReference;

public class ImageLoader {
    private static final String TAG = "ImageLoader";
    public static boolean sDebugSwitch = BasicConfig.getInstance().isDebuggable();
    private static final int MAX_BITMAP_POOL_SIZE = Build.VERSION.SDK_INT > 20 ? 0x1400000 : 0xA00000;
    private static final int MAX_RESOURCE_BITMAP_POOL_SIZE = Build.VERSION.SDK_INT > 20 ? 0x1400000 : 0xA00000;
    private static volatile YYLruResourceCache sGlideCache;
    private static volatile YYLruBitmapPool sBitmapPool;
    private static volatile ImageCache sNormalCache;
    private static int sBitmapPoolSize;
    private static int sResourceCacheSize;
    private static volatile boolean sLoadOrigin;
    private static volatile boolean sRecycleImageViewOn;
    private static volatile boolean sBigImageAutoRecycle;
    private static volatile int sBigRecycleSizeMultiplier;
    private static boolean sResetDrawableToNulling;

    public static void init(int bitmapPoolSize, int memCacheSize) {
        if (bitmapPoolSize > 0) {
            sBitmapPoolSize = bitmapPoolSize;
        }
        if (memCacheSize > 0) {
            sResourceCacheSize = memCacheSize;
        }
        if (BasicConfig.getInstance().getAppContext() instanceof Application) {
            IRecycler recycler = new IRecycler(){

                @Override
                public boolean recycle(RecycleImageView imageView) {
                    return ImageLoader.recycle(imageView);
                }

                @Override
                public boolean recovery(RecycleImageView imageView) {
                    return ImageLoader.recovery(imageView);
                }
            };
            GifHandler.init((Application)BasicConfig.getInstance().getAppContext(), recycler);
            BigPicRecycler.init((Application)BasicConfig.getInstance().getAppContext(), recycler);
        }
    }

    public static void updateSwitchs(boolean loadOrgin, boolean recycleImageViewOn, boolean bigImageAutoRecycle, int bigImageAutoRecycleSizeMultiplier) {
        sLoadOrigin = loadOrgin;
        sRecycleImageViewOn = recycleImageViewOn;
        sBigImageAutoRecycle = bigImageAutoRecycle;
        if (bigImageAutoRecycleSizeMultiplier > 0) {
            sBigRecycleSizeMultiplier = bigImageAutoRecycleSizeMultiplier;
        }
        BigPicRecycler.updateParams(sBigImageAutoRecycle, sBigRecycleSizeMultiplier);
    }

    public static YYLruBitmapPool getBitmapPool() {
        if (sBitmapPool == null) {
            sBitmapPool = new YYLruBitmapPool(sBitmapPoolSize);
        }
        return sBitmapPool;
    }

    public static YYLruResourceCache getResourceCache() {
        if (sGlideCache == null) {
            sGlideCache = new YYLruResourceCache(sResourceCacheSize);
        }
        return sGlideCache;
    }

    private static ImageCache getYYImageCache() {
        if (sNormalCache == null) {
            sNormalCache = new ImageCache(BasicConfig.getInstance().getAppContext());
        }
        return sNormalCache;
    }

    public static boolean isValidDimensions(int width, int height) {
        return ImageLoader.isValidDimension(width) && ImageLoader.isValidDimension(height);
    }

    private static boolean isValidDimension(int dimen) {
        return dimen > 0 || dimen == Integer.MIN_VALUE;
    }

    public static void loadImage(RecycleImageView recycleImageView, int placeholderId) {
        ImageLoader.loadImage(recycleImageView, null, placeholderId);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url) {
        ImageLoader.loadImage(recycleImageView, url, -1);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, int placeholderId) {
        ImageLoader.loadImage(recycleImageView, url, placeholderId, placeholderId);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, int placeholderId, int errorID) {
        ImageLoader.loadImage(recycleImageView, url, placeholderId, errorID, null);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, int placeholderId, int errorId, ImageLoadListener listener) {
        ImageLoader.loadImage(recycleImageView, url, placeholderId, errorId, null, null, -1.0f, listener);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, Drawable placeholderDrawable) {
        ImageLoader.loadImage(recycleImageView, url, -1, -1, placeholderDrawable, null, -1.0f, null);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, Drawable placeholderDrawable, Drawable errorDrawable, ImageLoadListener listener) {
        ImageLoader.loadImage(recycleImageView, url, -1, -1, placeholderDrawable, errorDrawable, -1.0f, listener);
    }

    public static void clear(RecycleImageView recycleImageView) {
        Glide.with((Context)BasicConfig.getInstance().getAppContext()).clear((View)recycleImageView);
    }

    public static void clearDiskCache() {
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Glide.get((Context)BasicConfig.getInstance().getAppContext()).clearDiskCache();
            }
        });
    }

    private static void loadImage(RecycleImageView recycleImageView, String url, int placeholderId, int errorId, Drawable placeholderDrawable, Drawable errorDrawable, float sizeMultiplier, ImageLoadListener listener) {
        if (recycleImageView == null || recycleImageView.getContext() == null) {
            return;
        }
        Object dataObject = recycleImageView.getTag(R.id.yy_image_data_id);
        if (dataObject instanceof ImageData) {
            ImageData data = (ImageData)dataObject;
            data.reset();
            data.url = url;
            data.placeholderId = placeholderId;
            data.errorId = errorId;
            if (sizeMultiplier > 0.0f) {
                data.sizeMultiplier = sizeMultiplier;
            }
            data.placeholderDrawable = placeholderDrawable;
            data.errorDrawable = errorDrawable;
            data.listener = listener;
            ImageLoader.loadImage(recycleImageView, data);
        } else {
            Builder builder = Builder.obtain(recycleImageView, url, placeholderId);
            if (sizeMultiplier > 0.0f) {
                builder.setSizeMultiplier(sizeMultiplier);
            }
            builder.error(errorId).setPlaceholderDrawable(placeholderDrawable).setErrorDrawable(errorDrawable).setListener(listener).load();
        }
    }

    public static void loadImage(final RecycleImageView imageView, final ImageData imageData) {
        if (imageData == null || imageView == null) {
            return;
        }
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postIdleRunnableToMainThread(new Runnable(){

                @Override
                public void run() {
                    ImageLoader.loadImageInner(imageView, imageData);
                }
            });
        } else {
            ImageLoader.loadImageInner(imageView, imageData);
        }
    }

    @SuppressLint(value={"CheckResult"})
    private static void loadImageInner(RecycleImageView imageView, ImageData imageData) {
        Context context;
        if (imageData.url != null && imageData.url.length() == 0) {
            imageData.url = null;
        }
        if (!(ImageLoader.isValidDimension(imageData.width) && ImageLoader.isValidDimension(imageData.heigth) || imageView.getLayoutParams() == null || imageView.getLayoutParams().width <= 0 || imageView.getLayoutParams().height <= 0)) {
            imageData.width = imageView.getLayoutParams().width;
            imageData.heigth = imageView.getLayoutParams().height;
        }
        if ((context = imageView.getContext()) instanceof Activity) {
            if (Build.VERSION.SDK_INT >= 17 && ((Activity)context).isDestroyed()) {
                return;
            }
            context = BasicConfig.getInstance().getAppContext();
        }
        if (BasicConfig.getInstance().isDebuggable() && sDebugSwitch && imageData.url != null) {
            MLog.info(TAG, "url:" + imageData.url, new Object[0]);
        }
        ImageLoader.clearHeadRequest(imageView);
        final String url = HttpsParser.convertToHttps(imageData.url);
        final ImageLoadListener listener = imageData.listener;
        RequestOptions requestOptions = new RequestOptions().diskCacheStrategy(imageData.skipDiskCache ? DiskCacheStrategy.NONE : DiskCacheStrategy.AUTOMATIC);
        if (!ImageLoader.isWebPUrl(imageData.url)) {
            if (ImageLoader.isGifUrl(imageData.url)) {
                Glide.with((Context)context).load(url).apply(new RequestOptions().error(imageData.errorDrawable).placeholder(imageData.errorDrawable)).listener((RequestListener)new RequestListener<Drawable>(){

                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        if (listener != null) {
                            listener.onResourceReady(resource);
                        }
                        ImageLoader.checkBitmapSize(ImageLoader.getBitmapFromCustomDrawable(resource), url);
                        return false;
                    }

                    public boolean onLoadFailed(@Nullable GlideException e, Object model, Target target, boolean isFirstResource) {
                        if (listener != null) {
                            listener.onLoadFailed((Exception)e);
                        }
                        MLog.error((Object)ImageLoader.TAG, "loadImage error:" + (url == null ? "" : url) + (e != null ? e.toString() : ""), new Object[0]);
                        return false;
                    }
                }).into((ImageView)imageView);
            } else {
                RequestManager requestManager = Glide.with((Context)context);
                RequestBuilder bitmapRequestBuilder = requestManager.asBitmap();
                if (imageData.placeholderDrawable != null) {
                    requestOptions.placeholder(imageData.placeholderDrawable);
                } else if (imageData.placeholderId != -1) {
                    requestOptions.placeholder(imageData.placeholderId);
                }
                if (imageData.errorDrawable != null) {
                    requestOptions.error(imageData.errorDrawable);
                } else if (imageData.errorId != -1) {
                    requestOptions.error(imageData.errorId);
                }
                if (imageData.width != -1 && imageData.heigth != -1) {
                    requestOptions.override(imageData.width, imageData.heigth);
                } else {
                    requestOptions.sizeMultiplier(imageData.sizeMultiplier);
                }
                if (imageData.transformations != null && imageData.transformations.length > 0) {
                    requestOptions.transforms((Transformation[])imageData.transformations);
                } else if (imageData.circle) {
                    requestOptions.transform((Transformation)new GlideCircleTransform());
                } else if (imageData.round) {
                    requestOptions.transform((Transformation)new GlideRoundTransform());
                }
                if (BasicConfig.getInstance().phoneType == 0) {
                    requestOptions.dontAnimate();
                }
                if (imageData.skipMemCache) {
                    requestOptions.skipMemoryCache(true);
                }
                if (listener != null || BasicConfig.getInstance().isDebuggable()) {
                    bitmapRequestBuilder.listener((RequestListener)new RequestListener<Bitmap>(){

                        public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource) {
                            if (listener != null) {
                                listener.onResourceReady(resource);
                            }
                            ImageLoader.checkBitmapSize(resource, url);
                            return false;
                        }

                        public boolean onLoadFailed(@Nullable GlideException e, Object model, Target target, boolean isFirstResource) {
                            if (listener != null) {
                                listener.onLoadFailed((Exception)e);
                            }
                            MLog.error((Object)ImageLoader.TAG, "loadImage error:" + (url == null ? "" : url) + (e != null ? e.toString() : ""), new Object[0]);
                            return false;
                        }
                    });
                }
                bitmapRequestBuilder.load(url).apply(requestOptions).into((ImageView)imageView);
            }
        }
        imageView.setTag(R.id.yy_image_data_id, imageData);
    }

    private static String getCacheKey(String url) {
        if (StringUtils.isEmpty(url).booleanValue()) {
            return url;
        }
        return HttpsParser.convertToHttps(url);
    }

    private static String getCacheKey(String url, int width, int height) {
        if (StringUtils.isEmpty(url).booleanValue()) {
            return url;
        }
        String convertUrl = HttpsParser.convertToHttps(url);
        if (convertUrl == null) {
            return convertUrl;
        }
        return new StringBuilder(convertUrl.length() + 12).append("#W").append(width).append("#H").append(height).append(convertUrl).toString();
    }

    public static boolean addBitmapToCache(String key, BitmapDrawable bitmap) {
        if (StringUtils.isEmpty(key).booleanValue()) {
            return false;
        }
        ImageLoader.getYYImageCache().addBitmapToCache(ImageLoader.getCacheKey(key), bitmap);
        return true;
    }

    public static boolean addBitmapToCache(String key, BitmapDrawable bitmap, ImageConfig imageConfig) {
        if (StringUtils.isEmpty(key).booleanValue()) {
            return false;
        }
        if (imageConfig == null) {
            ImageLoader.getYYImageCache().addBitmapToCache(ImageLoader.getCacheKey(key), bitmap);
        } else {
            ImageLoader.getYYImageCache().addBitmapToCache(ImageLoader.getCacheKey(key, imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight()), bitmap);
        }
        return true;
    }

    public static void removeBitmapFromCache(String key, ImageConfig imageConfig) {
        if (StringUtils.isEmpty(key).booleanValue()) {
            return;
        }
        if (imageConfig == null) {
            ImageLoader.getYYImageCache().removeBitmapFromCache(ImageLoader.getCacheKey(key));
        } else {
            ImageLoader.getYYImageCache().removeBitmapFromCache(ImageLoader.getCacheKey(key, imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight()));
        }
    }

    public static BitmapDrawable getBitmapFromCache(String key) {
        return ImageLoader.getBitmapFromCache(key, null);
    }

    public static BitmapDrawable getBitmapFromCache(String key, ImageConfig imageConfig) {
        if (StringUtils.isEmpty(key).booleanValue()) {
            return null;
        }
        if (imageConfig == null) {
            return ImageLoader.getYYImageCache().getBitmapFromMemCache(ImageLoader.getCacheKey(key));
        }
        return ImageLoader.getYYImageCache().getBitmapFromMemCache(ImageLoader.getCacheKey(key, imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight()));
    }

    public static void removeBitmapFromCache(String key) {
        ImageLoader.removeBitmapFromCache(key, null);
    }

    public static void loadBitmap(Context context, String url, BitmapLoadListener listener) {
        ImageLoader.loadBitmap(context, url, listener, ImageLoader.getDefaultMaxWidth(), ImageLoader.getDefaultMaxHeight(), false);
    }

    public static void pauseRequests() {
        Glide.with((Context)BasicConfig.getInstance().getAppContext()).pauseRequests();
    }

    public static void resumeRequests() {
        Glide.with((Context)BasicConfig.getInstance().getAppContext()).resumeRequests();
    }

    @SuppressLint(value={"CheckResult"})
    private static void loadBitmapInner(Context context, RecycleImageView recycleImageView, final String url, final BitmapLoadListener listener, int width, int height, boolean skipMemCache, boolean skipDiskCache, YYBitmapTransformation ... bitmapTransformations) {
        Context myContext = null;
        myContext = recycleImageView != null && recycleImageView.getContext() != null ? recycleImageView.getContext() : context;
        if (myContext instanceof Activity) {
            if (Build.VERSION.SDK_INT >= 17 && ((Activity)myContext).isDestroyed()) {
                return;
            }
            myContext = BasicConfig.getInstance().getAppContext();
        }
        if (myContext == null) {
            return;
        }
        if (BasicConfig.getInstance().isDebuggable() && sDebugSwitch) {
            MLog.info(TAG, "url:" + url, new Object[0]);
        }
        ImageLoader.clearHeadRequest(recycleImageView);
        int rWidth = Integer.MIN_VALUE;
        int rHeight = Integer.MIN_VALUE;
        if (recycleImageView != null && recycleImageView.getWidth() != 0 && recycleImageView.getHeight() != 0) {
            rWidth = recycleImageView.getWidth();
            rHeight = recycleImageView.getHeight();
            MLog.info(TAG, "recycleImageView width is " + recycleImageView.getWidth() + " height is " + recycleImageView.getHeight(), new Object[0]);
        }
        final WeakReference<RecycleImageView> imageView = new WeakReference<RecycleImageView>(recycleImageView);
        SimpleTarget<Bitmap> target = new SimpleTarget<Bitmap>(rWidth, rHeight){

            public void onResourceReady(@NonNull Bitmap bitmap, @Nullable Transition<? super Bitmap> transition) {
                RecycleImageView imageView1 = (RecycleImageView)imageView.get();
                if (imageView1 != null) {
                    imageView1.setTag(R.id.yy_glide_target_id, null);
                }
                if (listener != null) {
                    listener.onResourceReady(bitmap);
                }
                ImageLoader.checkBitmapSize(bitmap, url);
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                RecycleImageView imageView1 = (RecycleImageView)imageView.get();
                if (imageView1 != null) {
                    imageView1.setTag(R.id.yy_glide_target_id, null);
                }
                if (listener != null) {
                    listener.onLoadFailed(new RuntimeException("loadBitmap error"));
                }
                MLog.error((Object)ImageLoader.TAG, "loadBitmap error:" + url, new Object[0]);
            }

            public void onLoadCleared(Drawable placeholder) {
                RecycleImageView imageView1 = (RecycleImageView)imageView.get();
                if (imageView1 != null) {
                    imageView1.setTag(R.id.yy_glide_target_id, null);
                }
            }
        };
        if (recycleImageView != null) {
            recycleImageView.setTag(R.id.yy_glide_target_id, target);
        }
        RequestOptions requestOptions = new RequestOptions();
        if (bitmapTransformations != null && bitmapTransformations.length > 0) {
            requestOptions.transforms((Transformation[])bitmapTransformations);
        }
        requestOptions.diskCacheStrategy(skipDiskCache ? DiskCacheStrategy.NONE : DiskCacheStrategy.AUTOMATIC).skipMemoryCache(skipMemCache);
        Glide.with((Context)myContext).asBitmap().load(url).apply(requestOptions).into((Target)target);
    }

    public static void loadBitmap(Context context, String url, BitmapLoadListener listener, int maxWidth, int maxHeight, boolean skipCache) {
        ImageLoader.loadBitmap(context, url, listener, maxWidth, maxHeight, skipCache, null);
    }

    public static void loadBitmap(final Context context, final String url, final BitmapLoadListener listener, final int maxWidth, final int maxHeight, final boolean skipCache, final YYBitmapTransformation ... bitmapTransformations) {
        if (StringUtils.isNullOrEmpty(url)) {
            return;
        }
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postIdleRunnableToMainThread(new Runnable(){

                @Override
                public void run() {
                    ImageLoader.loadBitmapInner(context, null, url, listener, maxWidth, maxHeight, skipCache, skipCache, bitmapTransformations);
                }
            });
        } else {
            ImageLoader.loadBitmapInner(context, null, url, listener, maxWidth, maxHeight, skipCache, skipCache, bitmapTransformations);
        }
    }

    private static void loadBitmap(final RecycleImageView imageView, final String url, final BitmapLoadListener listener, final int maxWidth, final int maxHeight, final boolean skipMemCache, final boolean skipDiskCache, final YYBitmapTransformation ... bitmapTransformations) {
        if (StringUtils.isNullOrEmpty(url)) {
            return;
        }
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postIdleRunnableToMainThread(new Runnable(){

                @Override
                public void run() {
                    ImageLoader.loadBitmapInner(imageView.getContext(), imageView, url, listener, maxWidth, maxHeight, skipMemCache, skipDiskCache, bitmapTransformations);
                }
            });
        } else {
            ImageLoader.loadBitmapInner(imageView.getContext(), imageView, url, listener, maxWidth, maxHeight, skipMemCache, skipDiskCache, bitmapTransformations);
        }
    }

    public static void loadBitmap(Context context, String url, BitmapLoadListener listener, int maxWidth, int maxHeight) {
        ImageLoader.loadBitmap(context, url, listener, maxWidth, maxHeight, false);
    }

    private static void checkBitmapSize(Bitmap bitmap, String url) {
        if (url == null || bitmap == null) {
            return;
        }
        if (BasicConfig.getInstance().isDebuggable()) {
            int bitmapSize = bitmap.getByteCount();
            int allocationByteCount = 0;
            if (Build.VERSION.SDK_INT >= 19) {
                allocationByteCount = bitmap.getAllocationByteCount();
            }
            if (bitmapSize > 0x100000 || allocationByteCount > 0x100000) {
                MLog.info(TAG, "bitmap size is " + bitmapSize + ", allocationByteCount is " + allocationByteCount + ", please check! url:" + url, new Object[0]);
            }
        }
    }

    public static void preloadBitmap(String url, ImageConfig imageConfig, int resid) {
        int width = -1;
        int height = -1;
        if (imageConfig != null) {
            width = imageConfig.getImagePrecision().getWidth() * 2;
            height = imageConfig.getImagePrecision().getHeight() * 2;
        }
        ImageLoader.preloadBitmap(url, imageConfig, resid, width, height);
    }

    private static int getDefaultMaxWidth() {
        int width = (int)((float)ImageConfig.fullImageConfig().getImagePrecision().getWidth() * 0.85f);
        if (width <= 0) {
            width = Integer.MIN_VALUE;
        }
        return width;
    }

    private static int getDefaultMaxHeight() {
        int height = (int)((float)ImageConfig.fullImageConfig().getImagePrecision().getHeight() * 0.85f);
        if (height <= 0) {
            height = Integer.MIN_VALUE;
        }
        return height;
    }

    public static void preloadBitmap(final String url, final ImageConfig imageConfig, int resid, int maxWidth, int maxHeight) {
        int height;
        int width;
        if (ImageLoader.getBitmapFromCache(url, imageConfig) != null) {
            return;
        }
        if (resid > 0) {
            ImageUtil.getBitmapDrawableFromResource(resid, imageConfig);
        }
        if (maxHeight > 0 && maxWidth > 0) {
            width = maxWidth;
            height = maxHeight;
        } else {
            width = ImageLoader.getDefaultMaxWidth();
            height = ImageLoader.getDefaultMaxHeight();
        }
        if (!StringUtils.isEmpty(url).booleanValue()) {
            ImageLoader.loadBitmap(BasicConfig.getInstance().getAppContext(), url, new BitmapLoadListener(){

                @Override
                public void onLoadFailed(Exception e) {
                }

                @Override
                public void onResourceReady(Bitmap bitmap) {
                    if (bitmap != null) {
                        ImageLoader.addBitmapToCache(url, new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), bitmap), imageConfig);
                    }
                }
            }, width, height);
        }
    }

    private static ImageBitmapData getImageBitmapData(String url, int resid) {
        ImageBitmapData imageData = new ImageBitmapData();
        imageData.url = url;
        imageData.placeholderId = resid;
        return imageData;
    }

    private static void clearHeadRequest(RecycleImageView imageView) {
        if (imageView != null) {
            Object target = imageView.getTag(R.id.yy_glide_target_id);
            if (target instanceof Target) {
                Glide.with((Context)BasicConfig.getInstance().getAppContext()).clear((Target)target);
            }
            imageView.setTag(R.id.yy_glide_target_id, null);
        }
    }

    public static void loadBitmap(RecycleImageView imageView, String url, int placeResId) {
        if (url == null || imageView == null) {
            return;
        }
        ImageLoader.loadBitmap(imageView, url, placeResId, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static void loadBitmap(RecycleImageView imageView, final String url, final int placeResId, int maxWidth, int maxHeight) {
        if (url == null || imageView == null) {
            return;
        }
        BitmapDrawable drawableFromCache = ImageLoader.getBitmapFromCache(url);
        if (drawableFromCache != null) {
            ImageLoader.clearHeadRequest(imageView);
            imageView.setImageDrawable((Drawable)drawableFromCache);
            imageView.setTag(R.id.yy_image_data_id, ImageLoader.getImageBitmapData(url, placeResId));
            return;
        }
        imageView.setImageResource(placeResId);
        final WeakReference<RecycleImageView> fImageView = new WeakReference<RecycleImageView>(imageView);
        imageView.setTag(R.id.yy_image_data_id, ImageLoader.getImageBitmapData(url, placeResId));
        ImageLoader.loadBitmap(imageView, url, new BitmapLoadListener(){

            @Override
            public void onLoadFailed(Exception e) {
            }

            @Override
            public void onResourceReady(Bitmap bitmap) {
                if (bitmap != null) {
                    BitmapDrawable drawable2 = new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), bitmap);
                    ImageLoader.addBitmapToCache(url, drawable2);
                    RecycleImageView theImageView = (RecycleImageView)fImageView.get();
                    if (theImageView != null) {
                        theImageView.setImageDrawable((Drawable)drawable2);
                        theImageView.setTag(R.id.yy_image_data_id, ImageLoader.getImageBitmapData(url, placeResId));
                    }
                }
            }
        }, maxWidth, maxHeight, true, false, new YYBitmapTransformation[0]);
    }

    public static void savePhotoSync(String url, File saveTo) throws Exception {
        if (BasicConfig.getInstance().isDebuggable() && YYTaskExecutor.isMainThread()) {
            throw new RuntimeException("please don not call savePhotoSync in Main Thread!");
        }
        if (StringUtils.isEmpty(url).booleanValue() || saveTo == null) {
            throw new RuntimeException("savePhotoSync : url or saveto is null");
        }
        FutureTarget future = Glide.with((Context)BasicConfig.getInstance().getAppContext()).load(url).downloadOnly(Integer.MIN_VALUE, Integer.MIN_VALUE);
        File cacheFile = (File)future.get();
        if (cacheFile == null) {
            throw new RuntimeException("savePhotoSync : load url error" + url);
        }
        YYFileUtils.copyFile(cacheFile, saveTo);
    }

    public static Bitmap getBitmapFromCustomDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            if (drawable2 instanceof BitmapDrawable) {
                return ((BitmapDrawable)drawable2).getBitmap();
            }
            if (drawable2 instanceof GifDrawable) {
                return ((GifDrawable)drawable2).getFirstFrame();
            }
        }
        return null;
    }

    private static boolean isWebPUrl(String url) {
        if (StringUtils.isEmpty(url).booleanValue()) {
            return false;
        }
        return url.endsWith(".webp") || url.contains(".webp?imageview");
    }

    private static boolean isGifUrl(String url) {
        if (StringUtils.isEmpty(url).booleanValue()) {
            return false;
        }
        return url.endsWith(".gif") || url.contains(".gif?imageview");
    }

    public static void clearMemory() {
        if (BasicConfig.getInstance().getAppContext() != null) {
            Glide.get((Context)BasicConfig.getInstance().getAppContext()).clearMemory();
        }
        ImageLoader.getYYImageCache().cleanMemCache();
    }

    public static void trimMemory(int level) {
        if (BasicConfig.getInstance().getAppContext() != null) {
            Glide.get((Context)BasicConfig.getInstance().getAppContext()).trimMemory(level);
        }
        ImageLoader.getYYImageCache().cleanHalfMemCache();
    }

    public static BitmapDrawable getBitmapDrawableFromResource(int loadingBitmapResource, ImageConfig config) {
        return ImageUtil.getBitmapDrawableFromResource(loadingBitmapResource, config);
    }

    public static void loadImageResource(int resource, RecycleImageView recycleImageView, ImageConfig imageConfig) {
        ImageUtil.loadImageResource(resource, recycleImageView, imageConfig);
    }

    public static void loadImageResource(String resource, RecycleImageView recycleImageView, ImageConfig imageConfig, int blankBitmapResource) {
        ImageUtil.loadImageResource(resource, recycleImageView, imageConfig, blankBitmapResource);
    }

    public static void loadImageBackgroundResource(int resource, View view, ImageConfig imageConfig) {
        ImageUtil.loadImageBackgroundResource(resource, view, imageConfig);
    }

    public static void loadImageBackgroundResource(String resource, View view, ImageConfig imageConfig, int blankBitmapResource) {
        ImageUtil.loadImageBackgroundResource(resource, view, imageConfig, blankBitmapResource);
    }

    public static void loadImageBackgroundResource(String resource, RecycleImageView recycleImageView, ImageConfig imageConfig, int blankBitmapResource) {
        ImageUtil.loadImageBackgroundResource(resource, recycleImageView, imageConfig, blankBitmapResource);
    }

    public static boolean isGif(String url) {
        return ImageLoader.isGifUrl(url);
    }

    public static boolean isPng(String url) {
        return url != null && url.endsWith(".png");
    }

    public static boolean isJpg(String url) {
        return url != null && url.endsWith(".jpg");
    }

    private static boolean recycle(RecycleImageView imageView) {
        String url;
        if (imageView == null || !sRecycleImageViewOn) {
            return false;
        }
        Object data = imageView.getTag(R.id.yy_image_data_id);
        if (!(data instanceof ImageData) && !(data instanceof ImageBitmapData)) {
            return false;
        }
        String string = url = data instanceof ImageData ? ((ImageData)data).url : ((ImageBitmapData)data).url;
        if (!StringUtils.isNullOrEmpty(url)) {
            if (BasicConfig.getInstance().isDebuggable() && sDebugSwitch && MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, "RecycleImageView recycle url:" + url, new Object[0]);
            }
            sResetDrawableToNulling = true;
            Glide.with((Context)BasicConfig.getInstance().getAppContext()).clear((View)imageView);
            imageView.setImageDrawable(null);
            imageView.setTag(R.id.yy_recycled, true);
            sResetDrawableToNulling = false;
            return true;
        }
        return false;
    }

    public static void onDetachedFromWindow(RecycleImageView imageView) {
        MLog.info(TAG, "onDetachedFromWindow " + imageView.toString(), new Object[0]);
        ImageLoader.recycle(imageView);
    }

    private static boolean recovery(RecycleImageView imageView) {
        if (imageView == null) {
            return false;
        }
        Object recycled = imageView.getTag(R.id.yy_recycled);
        if (recycled instanceof Boolean && ((Boolean)recycled).booleanValue()) {
            String url;
            Object data = imageView.getTag(R.id.yy_image_data_id);
            if (!(data instanceof ImageData) && !(data instanceof ImageBitmapData)) {
                return false;
            }
            String string = url = data instanceof ImageData ? ((ImageData)data).url : ((ImageBitmapData)data).url;
            if (!StringUtils.isNullOrEmpty(url)) {
                if (BasicConfig.getInstance().isDebuggable() && sDebugSwitch && MLog.isLogLevelAboveDebug()) {
                    MLog.debug(TAG, "RecycleImageView recovery url:" + url, new Object[0]);
                }
                if (data instanceof ImageData) {
                    ImageLoader.loadImage(imageView, (ImageData)data);
                } else {
                    ImageLoader.loadBitmap(imageView, url, ((ImageBitmapData)data).placeholderId);
                }
                imageView.setTag(R.id.yy_recycled, false);
                if (!sRecycleImageViewOn) {
                    imageView.setTag(R.id.yy_image_data_id, null);
                }
                return true;
            }
        }
        if (!sRecycleImageViewOn) {
            imageView.setTag(R.id.yy_image_data_id, null);
        }
        return false;
    }

    public static void onAttachedFromWindow(RecycleImageView imageView) {
        ImageLoader.recovery(imageView);
    }

    public static void onImageDrawableUpdated(RecycleImageView imageView, Drawable drawable2) {
        GifHandler.onImageDrawableUpdated(imageView, drawable2);
        if (sResetDrawableToNulling && drawable2 == null) {
            return;
        }
        if (sRecycleImageViewOn) {
            if (drawable2 == null) {
                imageView.setTag(R.id.yy_image_data_id, null);
                imageView.setTag(R.id.yy_recycled, false);
            }
        } else {
            imageView.setTag(R.id.yy_image_data_id, null);
            imageView.setTag(R.id.yy_recycled, false);
        }
    }

    @Deprecated
    public static void loadImage(String url, RecycleImageView recycleImageView, ImageConfig imageConfig, int loadingBitmapResource) {
        ImageLoader.loadImage(url, recycleImageView, imageConfig, loadingBitmapResource, loadingBitmapResource);
    }

    @Deprecated
    public static void loadImage(String url, RecycleImageView recycleImageView, ImageConfig imageConfig, int loadingBitmapResource, int blankBitmapResource) {
        ImageLoader.loadImage(url, recycleImageView, imageConfig, loadingBitmapResource, blankBitmapResource, null, null, null);
    }

    private static void loadImage(String url, RecycleImageView recycleImageView, ImageConfig imageConfig, int loadingBitmapResource, int blankBitmapResource, Cache cache, ResponseListener responseListener, ResponseErrorListener responseErrorListener) {
        if (recycleImageView == null || imageConfig == null) {
            return;
        }
        if (!sLoadOrigin) {
            ImageLoader.loadImage(recycleImageView, url, loadingBitmapResource);
        } else {
            ImageLoader.loadBitmap(recycleImageView, url, loadingBitmapResource);
        }
    }

    @Deprecated
    public static void loadImage(String url, RecycleImageView recycleImageView, int imageWidth, int imageHeight, int loadingBitmapResource) {
        ImageLoader.loadImage(url, recycleImageView, imageWidth, imageHeight, loadingBitmapResource, loadingBitmapResource);
    }

    @Deprecated
    public static void loadImage(String url, RecycleImageView recycleImageView, int imageWidth, int imageHeight, int loadingBitmapResource, int blankBitmapResource) {
        ImageLoader.loadImage(url, recycleImageView, new ImageConfig(imageWidth, imageHeight), loadingBitmapResource, blankBitmapResource);
    }

    static {
        sBitmapPoolSize = MAX_BITMAP_POOL_SIZE;
        sResourceCacheSize = MAX_RESOURCE_BITMAP_POOL_SIZE;
        sLoadOrigin = false;
        sRecycleImageViewOn = true;
        sBigImageAutoRecycle = true;
        sBigRecycleSizeMultiplier = 5;
        sResetDrawableToNulling = false;
    }

    public static class ImageBitmapData {
        private static final int INVALID_ID = -1;
        public String url;
        public int placeholderId = -1;

        private ImageBitmapData() {
        }
    }

    public static class ImageData {
        private static final int INVALID_ID = -1;
        private static final int INVALID_SIZE = -1;
        public ImageLoadListener listener;
        public Drawable placeholderDrawable;
        public Drawable errorDrawable;
        public YYBitmapTransformation[] transformations;
        public String url;
        public float sizeMultiplier;
        public int placeholderId;
        public int errorId;
        public int width;
        public int heigth;
        public boolean circle;
        public boolean round;
        public boolean skipMemCache;
        public boolean skipDiskCache;

        private ImageData() {
            this.sizeMultiplier = BasicConfig.getInstance().phoneType == 0 ? 0.85f : 1.0f;
            this.placeholderId = -1;
            this.errorId = -1;
            this.width = -1;
            this.heigth = -1;
            this.circle = false;
            this.round = false;
            this.skipMemCache = false;
            this.skipDiskCache = false;
        }

        public void reset() {
            this.placeholderId = -1;
            this.errorId = -1;
            this.sizeMultiplier = BasicConfig.getInstance().phoneType == 0 ? 0.85f : 1.0f;
            this.width = -1;
            this.heigth = -1;
            this.circle = false;
            this.round = false;
            this.listener = null;
            this.placeholderDrawable = null;
            this.errorDrawable = null;
            this.transformations = null;
            this.skipMemCache = false;
            this.skipDiskCache = false;
        }
    }

    public static class Builder {
        private RecycleImageView mView;
        private ImageData mData;

        private Builder() {
        }

        public static Builder obtain(RecycleImageView recycleImageView, String url) {
            return new Builder(recycleImageView, url);
        }

        public static Builder obtain(RecycleImageView recycleImageView, String url, int placeholderId) {
            return new Builder(recycleImageView, url, placeholderId);
        }

        Builder(RecycleImageView recycleImageView, String url) {
            this(recycleImageView, url, -1);
        }

        Builder(RecycleImageView recycleImageView, String url, int placeholderId) {
            this.mView = recycleImageView;
            this.mData = new ImageData();
            this.mData.url = url;
            this.mData.placeholderId = placeholderId;
        }

        public Builder setImageData(RecycleImageView imageView, ImageData imageData) {
            this.mView = imageView;
            this.mData = imageData;
            return this;
        }

        public Builder error(int errorId) {
            this.mData.errorId = errorId;
            return this;
        }

        public Builder setPlaceholderDrawable(Drawable drawable2) {
            this.mData.placeholderDrawable = drawable2;
            return this;
        }

        public Builder setErrorDrawable(Drawable drawable2) {
            this.mData.errorDrawable = drawable2;
            return this;
        }

        public Builder override(int width, int height) {
            if (ImageLoader.isValidDimensions(width, height)) {
                this.mData.width = width;
                this.mData.heigth = height;
            } else if (BasicConfig.getInstance().isDebuggable()) {
                MLog.info(ImageLoader.TAG, "override:Width and height must be > 0", new Object[0]);
            }
            return this;
        }

        public Builder setSizeMultiplier(float sizeMultiplier) {
            this.mData.sizeMultiplier = sizeMultiplier;
            return this;
        }

        public Builder setCircle(boolean circle) {
            this.mData.circle = circle;
            return this;
        }

        public Builder setTransform(YYBitmapTransformation ... bitmapTransformations) {
            if (bitmapTransformations != null && bitmapTransformations.length > 0) {
                this.mData.transformations = new YYBitmapTransformation[bitmapTransformations.length];
                for (int i = 0; i < bitmapTransformations.length; ++i) {
                    this.mData.transformations[i] = bitmapTransformations[i];
                }
            } else {
                this.mData.transformations = null;
            }
            return this;
        }

        public Builder setRound(boolean round) {
            this.mData.round = round;
            return this;
        }

        public Builder skipCache(boolean skip) {
            this.mData.skipMemCache = skip;
            return this;
        }

        public Builder skipDiskCache(boolean skip) {
            this.mData.skipDiskCache = skip;
            return this;
        }

        public Builder setListener(ImageLoadListener listener) {
            this.mData.listener = listener;
            return this;
        }

        public void load() {
            ImageLoader.loadImage(this.mView, this.mData);
        }
    }

    public static interface ImageLoadListener {
        public void onLoadFailed(Exception var1);

        public void onResourceReady(Object var1);
    }

    public static interface BitmapLoadListener {
        public void onLoadFailed(Exception var1);

        public void onResourceReady(Bitmap var1);
    }
}

