/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.javascript.apiModule;

import android.text.TextUtils;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.javascript.apiModule.IApiModuleManager;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ApiModuleManager
implements IApiModuleManager {
    private static final String TAG = "ApiModuleManager";
    private Map<String, IApiModule> apiModuleMap = new ConcurrentHashMap<String, IApiModule>();

    @Override
    public void addModule(IApiModule apiModule) {
        if (!TextUtils.isEmpty((CharSequence)apiModule.moduleName())) {
            this.apiModuleMap.put(apiModule.moduleName(), apiModule);
        } else {
            MLog.warn(TAG, "invalid module name, skip mapping.", new Object[0]);
        }
    }

    @Override
    public void removeModule(IApiModule apiModule) {
        this.apiModuleMap.remove(apiModule.moduleName());
        apiModule.release();
    }

    @Override
    public void removeModuleByName(String name) {
        this.apiModuleMap.remove(name);
    }

    @Override
    public IApiModule getModule(String name) {
        return this.apiModuleMap.get(name);
    }

    public void release() {
        ArrayList<IApiModule> copyOnModify = new ArrayList<IApiModule>(this.apiModuleMap.values());
        this.apiModuleMap.clear();
        for (IApiModule entry : copyOnModify) {
            entry.release();
        }
    }
}

