/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.AppMetaDataUtil;

public class VersionUtil {
    static int[] sLocalVer = null;
    static String sLocalName = null;
    private static final String SNAPSHOT = "-SNAPSHOT";
    private static final String DOT = ".";

    public static Ver getVerFromStr(String version) {
        String normalVer = version;
        if (version != null && version.contains(SNAPSHOT)) {
            normalVer = version.substring(0, version.indexOf(SNAPSHOT));
        }
        if (normalVer != null && normalVer.matches("\\d{1,}.\\d{1,}.\\d{1,}\\D*")) {
            Ver ver = new Ver();
            int dotPos = normalVer.indexOf(DOT);
            int prevPos = 0;
            ver.mMajor = Integer.valueOf(normalVer.substring(prevPos, dotPos));
            prevPos = dotPos + 1;
            dotPos = normalVer.indexOf(DOT, prevPos);
            ver.mMinor = Integer.valueOf(normalVer.substring(prevPos, dotPos));
            prevPos = dotPos + 1;
            ver.mBuild = Integer.valueOf(normalVer.substring(prevPos).replaceAll("\\D*", ""));
            ver.isSnapshot = version.contains(SNAPSHOT);
            return ver;
        }
        return null;
    }

    public static Ver getLocalVer(Context c) {
        Ver v = new Ver();
        int[] ver = VersionUtil.getLocal(c);
        if (ver != null && ver.length > 0) {
            v.mMajor = ver[0];
            if (ver.length > 1) {
                v.mMinor = ver[1];
                if (ver.length > 2) {
                    v.mBuild = ver[2];
                    if (ver.length > 3) {
                        v.isSnapshot = ver[3] == 1;
                    }
                }
            }
        }
        return v;
    }

    public static String getLocalName(Context c) {
        if (sLocalName != null) {
            return sLocalName;
        }
        try {
            VersionUtil.loadLoaclVer(c);
        }
        catch (Exception e) {
            sLocalVer = new int[4];
            VersionUtil.sLocalVer[0] = 0;
            VersionUtil.sLocalVer[1] = 0;
            VersionUtil.sLocalVer[2] = 0;
            VersionUtil.sLocalVer[3] = 0;
        }
        return sLocalName;
    }

    public static int[] getLocal(Context c) {
        if (sLocalVer != null) {
            return (int[])sLocalVer.clone();
        }
        try {
            VersionUtil.loadLoaclVer(c);
        }
        catch (Exception e) {
            sLocalVer = new int[4];
            VersionUtil.sLocalVer[0] = 0;
            VersionUtil.sLocalVer[1] = 0;
            VersionUtil.sLocalVer[2] = 0;
            VersionUtil.sLocalVer[3] = 0;
        }
        return (int[])sLocalVer.clone();
    }

    public static int getVersionCode(Context c) {
        int verCode = 0;
        try {
            verCode = c.getPackageManager().getPackageInfo((String)c.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"VersionUtil", (String)"Empty Catch on getVersionCode", (Throwable)e);
        }
        return verCode;
    }

    static void loadLoaclVer(Context c) {
        try {
            sLocalName = c.getPackageManager().getPackageInfo((String)c.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Local Ver Package Error");
        }
        if (sLocalName == null) {
            throw new RuntimeException("Local Ver VersionName Not Exist");
        }
        Ver ver = VersionUtil.getVerFromStr(sLocalName);
        sLocalVer = ver.toVerCode();
    }

    public static class Ver {
        public int mMajor;
        public int mMinor;
        public int mBuild;
        public boolean isSnapshot;

        public boolean bigThan(Ver v) {
            return this.mMajor > v.mMajor || this.mMajor == v.mMajor && this.mMinor > v.mMinor || this.mMajor == v.mMajor && this.mMinor == v.mMinor && this.mBuild > v.mBuild;
        }

        public boolean smallThan(Ver v) {
            return this.mMajor < v.mMajor || this.mMajor == v.mMajor && this.mMinor < v.mMinor || this.mMajor == v.mMajor && this.mMinor == v.mMinor && this.mBuild < v.mBuild;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            Ver v = (Ver)o;
            return this.mMajor == v.mMajor && this.mMinor == v.mMinor && this.mBuild == v.mBuild;
        }

        public String getVersionName(Context c) {
            if (this.isSnapshot) {
                return String.format("%d.%d.%d", 0, AppMetaDataUtil.getSvnBuildVersion(c), VersionUtil.getVersionCode(c));
            }
            return String.format("%d.%d.%d", this.mMajor, this.mMinor, this.mBuild);
        }

        public String aboutDisplayName(Context c) {
            if (this.isSnapshot) {
                return String.format("%d.%d.%d-%s(%d.%d.%d)%s", this.mMajor, this.mMinor, this.mBuild, "\u5185\u6d4b\u7248", 0, AppMetaDataUtil.getSvnBuildVersion(c), VersionUtil.getVersionCode(c), BasicConfig.getInstance().isDebuggable() ? "D" : "");
            }
            return String.format("%d.%d.%d", this.mMajor, this.mMinor, this.mBuild);
        }

        public String feedbackVersionName(Context c) {
            if (this.isSnapshot) {
                return String.format("%d.%d.%d-dev(%d.%d.%d)%s", this.mMajor, this.mMinor, this.mBuild, 0, AppMetaDataUtil.getSvnBuildVersion(c), VersionUtil.getVersionCode(c), BasicConfig.getInstance().isDebuggable() ? "D" : "");
            }
            return String.format("%d.%d.%d", this.mMajor, this.mMinor, this.mBuild);
        }

        public String toString() {
            if (this.isSnapshot) {
                return String.format("%d.%d.%d(SNAPSHOT, Build %s)", this.mMajor, this.mMinor, this.mBuild, VersionUtil.getVersionCode(BasicConfig.getInstance().getAppContext()));
            }
            return String.format("%d.%d.%d", this.mMajor, this.mMinor, this.mBuild);
        }

        public int[] toVerCode() {
            int[] ver = new int[]{this.mMajor, this.mMinor, this.mBuild, this.isSnapshot ? 1 : 0};
            return ver;
        }

        public String getVersionNameWithoutSnapshot() {
            return String.format("%d.%d.%d", this.mMajor, this.mMinor, this.mBuild);
        }

        public String getVersionNameFor3GReq() {
            String versionName = this.getVersionNameWithoutSnapshot();
            if (this.isSnapshot || BasicConfig.getInstance().isDebuggable()) {
                versionName = versionName + "_beta";
            }
            return versionName;
        }

        public String getOriginalVersion() {
            return sLocalName;
        }
    }
}

