/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.yy.mobile.util.MD5Utils;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.SHAUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yy.mobile.util.valid.BlankUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Properties;

public class TelephonyUtils {
    private static final String TAG = "TelephonyUtils";
    private static TelephonyApi sTelephonyApi;
    public static final String COMMON_SHAREDPREF_IMSI = "common_sharedpref_imsi";
    private static volatile String sImsi;
    private static int sImsiTryTimes;
    private static volatile boolean sImsiUpdated;
    public static final String COMMON_SHAREDPREF_IMEI = "common_sharedpref_imei";
    private static volatile String sImei;
    private static int sImeiTryTimes;
    private static volatile boolean sImeiUpdated;
    private static final String KEY_MIUI_VERSION_CODE = "ro.miui.ui.version.code";
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_MIUI_INTERNAL_STORAGE = "ro.miui.internal.storage";

    public static void setTelephonyApi(TelephonyApi telephonyApi) {
        sTelephonyApi = telephonyApi;
    }

    public static String getSimOperator(Context c) {
        try {
            TelephonyManager tm = (TelephonyManager)c.getSystemService("phone");
            return tm.getSimOperator();
        }
        catch (Exception ex) {
            Log.e((String)TelephonyUtils.class.toString(), (String)("getSimOperator e = " + ex));
            return "";
        }
    }

    public static String getOperator(Context c) {
        String sim = TelephonyUtils.getSimOperator(c);
        if (BlankUtil.isBlank(sim)) {
            Log.i((String)TAG, (String)"No sim operator.");
            return "Unknown";
        }
        if (sim.startsWith("46003") || sim.startsWith("46005")) {
            return "CTL";
        }
        if (sim.startsWith("46001") || sim.startsWith("46006")) {
            return "UNICOM";
        }
        if (sim.startsWith("46000") || sim.startsWith("46002") || sim.startsWith("46007") || sim.startsWith("46020")) {
            return "CMCC";
        }
        return "Unknown";
    }

    public static boolean hasSimCard(Context c) {
        return TelephonyUtils.isSIMCardOK(c);
    }

    private static boolean isSIMCardOK(Context c) {
        try {
            TelephonyManager telMgr = (TelephonyManager)c.getSystemService("phone");
            int s = telMgr.getSimState();
            Log.i((String)TelephonyUtils.class.toString(), (String)("SIM state = " + s));
            if (s == 5) {
                return true;
            }
            boolean isDual = TelephonyUtils.isDualSIM(c);
            if (isDual && s != 1) {
                return true;
            }
        }
        catch (Throwable ex) {
            Log.e((String)TelephonyUtils.class.toString(), (String)("isSIMCardOK e = " + ex));
        }
        return false;
    }

    public static boolean isDualSIM(Context c) {
        try {
            Class<SmsManager> smsManagerClass = SmsManager.class;
            Method[] methods = smsManagerClass.getDeclaredMethods();
            int num = 0;
            int publicNum = 0;
            for (Method e : methods) {
                if (!e.getName().equals("sendTextMessage")) continue;
                ++num;
                if (!Modifier.isPublic(e.getModifiers())) continue;
                ++publicNum;
            }
            Log.i((String)TelephonyUtils.class.toString(), (String)("There are " + num + " sendTextMessage methods."));
            return publicNum >= 2;
        }
        catch (Throwable e) {
            Log.e((String)TelephonyUtils.class.toString(), (String)("Exeption when printSmsAPI " + e.toString()));
            return false;
        }
    }

    public static boolean isMtkDualSIM(Context c) {
        boolean dual = false;
        Method method = null;
        Object result0 = null;
        Object result1 = null;
        try {
            TelephonyManager tm = (TelephonyManager)c.getSystemService("phone");
            method = TelephonyManager.class.getMethod("getSimStateGemini", Integer.TYPE);
            result0 = method.invoke((Object)tm, 0);
            result1 = method.invoke((Object)tm, 1);
            Log.i((String)NetworkUtils.class.toString(), (String)("isDualSIM check " + result0 + ", " + result1));
            dual = true;
        }
        catch (Exception e) {
            Log.e((String)NetworkUtils.class.toString(), (String)("call MTK API getSimStateGemini e = " + e));
        }
        return dual;
    }

    public static boolean getDualSIMStatesForMtk(Context c, int[] twoOuts) {
        Method method = null;
        Object result0 = null;
        Object result1 = null;
        TelephonyManager tm = (TelephonyManager)c.getSystemService("phone");
        try {
            method = TelephonyManager.class.getMethod("getSimStateGemini", Integer.TYPE);
            result0 = method.invoke((Object)tm, 0);
            result1 = method.invoke((Object)tm, 1);
            Log.i((String)NetworkUtils.class.toString(), (String)("isDualSIM check " + result0 + ", " + result1));
            if (result0 instanceof Integer) {
                twoOuts[0] = (Integer)result0;
            }
            if (result1 instanceof Integer) {
                twoOuts[1] = (Integer)result1;
            }
            return result0 instanceof Integer && result1 instanceof Integer;
        }
        catch (Exception e) {
            Log.i((String)NetworkUtils.class.toString(), (String)("call MTK API getSimStateGemini e = " + e));
            return false;
        }
    }

    public static boolean checkPermissions(Context context, String permission) {
        boolean result = false;
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                Class<?> e = Class.forName("android.content.Context");
                Method method = e.getMethod("checkSelfPermission", String.class);
                int rest = (Integer)method.invoke((Object)context, permission);
                result = rest == 0;
            } else {
                PackageManager e1 = context.getPackageManager();
                if (e1.checkPermission(permission, context.getPackageName()) == 0) {
                    result = true;
                }
            }
        }
        catch (Throwable throwable) {
            MLog.error("checkPermissions", throwable);
        }
        return result;
    }

    private static String getIMSIInner(Context context) {
        String imsi = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                imsi = telephonyManager.getSubscriberId();
            }
        }
        catch (Throwable ex) {
            MLog.error((Object)"getImsi", "getIMSI e occurs : " + ex, new Object[0]);
        }
        return MD5Utils.getMD5String(imsi);
    }

    public static String getIMSI(final Context context) {
        if (sImsiTryTimes >= 3) {
            return sImsi == null ? "" : sImsi;
        }
        sImsi = CommonPref.instance().getString(COMMON_SHAREDPREF_IMSI, null);
        if (sImsi == null) {
            ++sImsiTryTimes;
            sImsi = TelephonyUtils.getIMSIInner(context);
            if (sImsi != null) {
                CommonPref.instance().putString(COMMON_SHAREDPREF_IMSI, sImsi);
            }
            return sImsi == null ? "" : sImsi;
        }
        if (!sImsiUpdated) {
            sImsiUpdated = true;
            YYTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    String imsi = TelephonyUtils.getIMSIInner(context);
                    if (imsi != null) {
                        sImsi = imsi;
                        CommonPref.instance().putString(TelephonyUtils.COMMON_SHAREDPREF_IMSI, sImsi);
                    }
                }
            }, 0L);
        }
        return sImsi;
    }

    private static String getIMEIInner(Context context) {
        String imei = null;
        try {
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            if (manager != null) {
                imei = manager.getDeviceId();
            }
            if (imei != null && (BlankUtil.isBlank(imei) || imei.matches("0+") || imei.equals("004999010640000"))) {
                imei = "";
            }
        }
        catch (Exception ex) {
            MLog.error((Object)"getImei", "getIMeI e occurs : " + ex, new Object[0]);
        }
        return MD5Utils.getMD5String(imei);
    }

    public static String getImei(Context context) {
        String imei = "";
        if (sTelephonyApi != null) {
            imei = sTelephonyApi.getImei(context);
        } else {
            MLog.error((Object)TAG, "TelephonyApi not set before get imei", new Object[0]);
            imei = TelephonyUtils.getImeiByDefault(context);
        }
        if (TextUtils.isEmpty((CharSequence)imei)) {
            return "";
        }
        return SHAUtils.getSHA256(imei);
    }

    public static String getDefaultImei() {
        return CommonPref.instance().getString(COMMON_SHAREDPREF_IMEI, null);
    }

    private static String getImeiByDefault(final Context context) {
        if (sImeiTryTimes >= 3) {
            return sImei == null ? "" : sImei;
        }
        sImei = CommonPref.instance().getString(COMMON_SHAREDPREF_IMEI, null);
        if (sImei == null) {
            ++sImeiTryTimes;
            sImei = TelephonyUtils.getIMEIInner(context);
            if (sImei != null) {
                CommonPref.instance().putString(COMMON_SHAREDPREF_IMEI, sImei);
            }
            return sImei == null ? "" : sImei;
        }
        if (!sImeiUpdated) {
            sImeiUpdated = true;
            YYTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    String imei = TelephonyUtils.getIMSIInner(context);
                    if (imei != null) {
                        sImei = imei;
                        CommonPref.instance().putString(TelephonyUtils.COMMON_SHAREDPREF_IMEI, sImei);
                    }
                }
            }, 0L);
        }
        return sImei;
    }

    public static boolean isMIUI() throws IOException {
        try (InputStream stream = null;){
            Properties properties = new Properties();
            stream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
            properties.load(stream);
            boolean bl = properties.getProperty(KEY_MIUI_VERSION_CODE, null) != null || properties.getProperty(KEY_MIUI_VERSION_NAME, null) != null || properties.getProperty(KEY_MIUI_INTERNAL_STORAGE, null) != null;
            return bl;
        }
    }

    public static boolean isFlyme() {
        try {
            Method method = Build.class.getMethod("hasSmartBar", new Class[0]);
            return method != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getMac(Context c) {
        return NetworkUtils.getMac(c);
    }

    static {
        sImsi = null;
        sImsiTryTimes = 0;
        sImsiUpdated = false;
        sImei = null;
        sImeiTryTimes = 0;
        sImeiUpdated = false;
    }

    public static interface TelephonyApi {
        public String getImei(Context var1);
    }

    public static class ChinaOperator {
        public static final String CMCC = "CMCC";
        public static final String CTL = "CTL";
        public static final String UNICOM = "UNICOM";
        public static final String UNKNOWN = "Unknown";
    }
}

