/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.MD5Utils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetworkUtils {
    private static final String TAG = "NetworkUtils";
    private static NetWorkApi sNetWorkApi;
    public static final int NET_INVALID = 0;
    public static final int NET_WIFI = 1;
    public static final int NET_2G = 2;
    public static final int NET_3G = 3;
    public static final int NET_4G = 4;
    public static final int UNKNOW_NETWORK_TYPE = 5;
    public static final String NET_NAME_WIFI = "wifi";
    public static final String NET_NAME_2G = "2g";
    public static final String NET_NAME_3G = "3g";
    public static final String NET_NAME_4G = "4g";
    public static final String NET_NAME_UNKNOWN = "unknown";
    private static volatile String sSimOperator;
    private static BroadcastReceiver sNetWorkBroadcastReceiver;
    private static Runnable sGetNetInfoRunnable;
    private static Runnable sGetNetInfoRetryRunnable;
    private static volatile String sLocalIpAddress;
    private static volatile String sMac;
    private static volatile String sWifiMacAddr;
    private static volatile NetworkInfo sNetworkInfo;
    public static final String IPADDRESS_URL = "http://nstool.netease.com/";
    private static final String HTTP_PAT = "(http://|https://){1}[\\w\\.\\-/:]+";
    private static final String IPADRRESS_PAT = "\\d+\\.\\d+\\.\\d+\\.\\d+";
    private static IpDnsInfo mIpDnsInfo;
    private static int sRetryTimes;

    public static synchronized void setNetWorkApi(NetWorkApi netWorkApi) {
        sNetWorkApi = netWorkApi;
    }

    public static boolean isWifiActive(Context c) {
        if (c == null) {
            MLog.error((Object)"xuwakao", "isWifiActive is NULL", new Object[0]);
            return false;
        }
        NetworkInfo networkInfo = NetworkUtils.getActiveNetwork(c);
        return networkInfo != null && networkInfo.getType() == 1;
    }

    public static boolean isNetworkStrictlyAvailable(Context c) {
        try {
            if (c == null) {
                MLog.error((Object)"xuwakao", "isNetworkStrictlyAvailable context is NULL", new Object[0]);
                return false;
            }
            NetworkInfo ni = NetworkUtils.getActiveNetwork(c);
            if (ni != null && ni.isAvailable() && ni.isConnected()) {
                return true;
            }
            String info = null;
            info = ni != null ? "network type = " + ni.getType() + ", " + (ni.isAvailable() ? "available" : "inavailable") + ", " + (ni.isConnected() ? "" : "not") + " connected, " + (ni.isConnectedOrConnecting() ? "" : "not") + " isConnectedOrConnecting" : "no active network";
            MLog.error((Object)TAG, "isNetworkStrictlyAvailable network info" + info, new Object[0]);
            return false;
        }
        catch (Throwable throwable) {
            MLog.error(TAG, throwable);
            return false;
        }
    }

    public static boolean isNetworkAvailable(Context c) {
        if (c == null) {
            return false;
        }
        NetworkInfo ni = NetworkUtils.getActiveNetwork(c);
        if (ni != null && (ni.isConnected() || ni.isAvailable() && ni.isConnectedOrConnecting())) {
            return true;
        }
        String info = null;
        info = ni != null ? "network type = " + ni.getType() + ", " + (ni.isAvailable() ? "available" : "inavailable") + ", " + (ni.isConnected() ? "" : "not") + " connected, " + (ni.isConnectedOrConnecting() ? "" : "not") + " isConnectedOrConnecting" : "no active network";
        MLog.error((Object)TAG, "isNetworkAvailable network info" + info, new Object[0]);
        return false;
    }

    public static boolean pingHost(String host) {
        boolean result = false;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec("ping -c 1 -w 10 " + host);
            proc.waitFor();
            result = proc.exitValue() == 0;
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "Empty Catch on pingHost" + e, new Object[0]);
        }
        return result;
    }

    public static String getIpString(int ip) {
        StringBuilder sb = new StringBuilder();
        sb.append(ip & 0xFF);
        sb.append(".");
        sb.append(ip >>> 8 & 0xFF);
        sb.append(".");
        sb.append(ip >>> 16 & 0xFF);
        sb.append(".");
        sb.append(ip >>> 24 & 0xFF);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(ByteBuffer buffer) {
        if (buffer == null) {
            return new byte[0];
        }
        int savedPos = buffer.position();
        int savedLimit = buffer.limit();
        try {
            byte[] array = new byte[buffer.limit() - buffer.position()];
            if (buffer.hasArray()) {
                int offset = buffer.arrayOffset() + savedPos;
                byte[] bufferArray = buffer.array();
                System.arraycopy(bufferArray, offset, array, 0, array.length);
                byte[] byArray = array;
                return byArray;
            }
            buffer.get(array);
            byte[] byArray = array;
            return byArray;
        }
        finally {
            buffer.position(savedPos);
            buffer.limit(savedLimit);
        }
    }

    private static NetworkInfo getActiveNetworkFromService(Context c) {
        try {
            ConnectivityManager cm;
            if (c != null && (cm = (ConnectivityManager)c.getSystemService("connectivity")) != null) {
                return cm.getActiveNetworkInfo();
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "error on getActiveNetworkInfo " + e, new Object[0]);
        }
        return null;
    }

    private static NetworkInfo getActiveNetwork(Context c) {
        NetworkInfo tmpNetworkInfo = sNetworkInfo;
        if (tmpNetworkInfo == null) {
            tmpNetworkInfo = NetworkUtils.getActiveNetworkFromService(c);
        } else {
            if (tmpNetworkInfo.isAvailable() && tmpNetworkInfo.isConnectedOrConnecting()) {
                return tmpNetworkInfo;
            }
            tmpNetworkInfo = NetworkUtils.getActiveNetworkFromService(c);
        }
        sNetworkInfo = tmpNetworkInfo;
        return tmpNetworkInfo;
    }

    public static String getNetworkName(Context context) {
        String networkName = NET_NAME_UNKNOWN;
        switch (NetworkUtils.getNetworkType(context)) {
            case 1: {
                networkName = NET_NAME_WIFI;
                break;
            }
            case 2: {
                networkName = NET_NAME_2G;
                break;
            }
            case 3: {
                networkName = NET_NAME_3G;
                break;
            }
            case 4: {
                networkName = NET_NAME_4G;
                break;
            }
            case 5: {
                networkName = NET_NAME_UNKNOWN;
                break;
            }
        }
        return networkName;
    }

    public static int getNetworkType(Context c) {
        int networkType = 5;
        NetworkInfo netInfo = NetworkUtils.getActiveNetwork(c);
        if (netInfo != null) {
            int type = netInfo.getType();
            if (type == 1 || type == 6) {
                networkType = 1;
            } else if (type == 0) {
                int subType = netInfo.getSubtype();
                if (subType == 7 || subType == 3 || subType == 14 || subType == 5 || subType == 6 || subType == 12 || subType == 8 || subType == 10 || subType == 15 || subType == 9) {
                    networkType = 3;
                } else if (subType == 1 || subType == 4 || subType == 2 || subType == 11) {
                    networkType = 2;
                } else if (subType == 13) {
                    networkType = 4;
                }
            }
        }
        return networkType;
    }

    private static String getSimOperator(Context c) {
        TelephonyManager tm = (TelephonyManager)c.getSystemService("phone");
        return tm.getSimOperator();
    }

    public static String getOperator(Context c) {
        String sim;
        if (StringUtils.isEmpty(sSimOperator).booleanValue()) {
            sSimOperator = NetworkUtils.getSimOperator(c);
        }
        if (FP.empty(sim = sSimOperator)) {
            return "Unknown";
        }
        if (sim.startsWith("46003") || sim.startsWith("46005")) {
            return "CTL";
        }
        if (sim.startsWith("46001") || sim.startsWith("46006")) {
            return "UNICOM";
        }
        if (sim.startsWith("46000") || sim.startsWith("46002") || sim.startsWith("46007") || sim.startsWith("46020")) {
            return "CMCC";
        }
        return "Unknown";
    }

    public static synchronized void init(Context context) {
        NetworkUtils.registerNetWorkReceiver(context);
    }

    private static synchronized void registerNetWorkReceiver(Context context) {
        if (sNetWorkBroadcastReceiver == null) {
            sNetWorkBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    NetworkUtils.onNetConnectChanged(context);
                    NetworkUtils.onGetIpAddress();
                }
            };
            IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver(sNetWorkBroadcastReceiver, filter);
        }
    }

    public static IpDnsInfo getIpDnsInfo() {
        return mIpDnsInfo;
    }

    public static void getIpAddress(String url, RequestParam param, final ResponseListener<IpDnsInfo> successListener, final ResponseErrorListener errorlistener) {
        if (!RequestManager.instance().isInit()) {
            return;
        }
        RequestManager.instance().submitStringQueryRequest(url, param, new ResponseListener<String>(){

            @Override
            public void onResponse(String response) {
                String httpPatUrl = NetworkUtils.getHttpPat(response);
                RequestManager.instance().submitStringQueryRequest(httpPatUrl, null, new ResponseListener<String>(){

                    @Override
                    public void onResponse(String response) {
                        IpDnsInfo ipDnsInfo = new IpDnsInfo();
                        ipDnsInfo = NetworkUtils.praseIpDnsInfo(response);
                        successListener.onResponse(ipDnsInfo);
                    }
                }, new ResponseErrorListener(){

                    @Override
                    public void onErrorResponse(RequestError error) {
                        MLog.info(NetworkUtils.TAG, "onErrorResponse " + error, new Object[0]);
                        errorlistener.onErrorResponse(error);
                    }
                }, false);
            }
        }, new ResponseErrorListener(){

            @Override
            public void onErrorResponse(RequestError error) {
                MLog.info(NetworkUtils.TAG, "onErrorResponse " + error, new Object[0]);
                errorlistener.onErrorResponse(error);
            }
        }, false);
    }

    private static String getHttpPat(String response) {
        Pattern pattern = Pattern.compile(HTTP_PAT);
        StringBuffer httpPatBuf = new StringBuffer();
        String url = null;
        MLog.verbose(TAG, "getHttpPat length:" + response.length(), new Object[0]);
        Matcher matcher = pattern.matcher(response);
        while (matcher.find()) {
            httpPatBuf.append(matcher.group());
        }
        url = httpPatBuf.toString();
        return url;
    }

    private static IpDnsInfo praseIpDnsInfo(String response) {
        MLog.verbose(TAG, "praseDns length:" + response.length(), new Object[0]);
        IpDnsInfo ipDnsInfo = new IpDnsInfo();
        Pattern pattern = Pattern.compile(IPADRRESS_PAT);
        Matcher matcher = pattern.matcher(response);
        StringBuffer buffer = new StringBuffer();
        boolean ipFlag = true;
        while (matcher.find()) {
            if (ipFlag) {
                ipDnsInfo.setIp(matcher.group());
                ipFlag = false;
                continue;
            }
            ipDnsInfo.setDns(matcher.group());
        }
        return ipDnsInfo;
    }

    private static void onGetIpAddress() {
        ResponseListener<IpDnsInfo> successListener = new ResponseListener<IpDnsInfo>(){

            @Override
            public void onResponse(IpDnsInfo response) {
                mIpDnsInfo.setIp(response.getIp());
                mIpDnsInfo.setDns(response.getDns());
                MLog.info(NetworkUtils.TAG, "IpAddress is:" + response.getIp(), new Object[0]);
                MLog.info(NetworkUtils.TAG, "DnsAddress is:" + response.getDns(), new Object[0]);
            }
        };
        ResponseErrorListener errorListener = new ResponseErrorListener(){

            @Override
            public void onErrorResponse(RequestError error) {
                MLog.info(NetworkUtils.TAG, "onErrorResponse " + error, new Object[0]);
            }
        };
        NetworkUtils.getIpAddress(IPADDRESS_URL, null, successListener, errorListener);
    }

    private static void onNetConnectChanged(final Context context) {
        sRetryTimes = 0;
        if (sGetNetInfoRunnable == null) {
            sGetNetInfoRunnable = new Runnable(){

                @Override
                public void run() {
                    NetworkUtils.updateActiveNetwork(context);
                    sLocalIpAddress = NetworkUtils.getLocalIpAddressFromService();
                    sMac = NetworkUtils.getMacFromService(context);
                    String macFromService = NetworkUtils.getMacFromService(context);
                    if ("YY_FAKE_MAC".equals(macFromService)) {
                        sWifiMacAddr = "";
                    } else {
                        sWifiMacAddr = macFromService;
                    }
                    if (NetworkUtils.isNetworkAvailable(context)) {
                        sGetNetInfoRunnable = null;
                        sRetryTimes = 0;
                        sGetNetInfoRetryRunnable = null;
                    } else if (sGetNetInfoRetryRunnable == null) {
                        sGetNetInfoRetryRunnable = new Runnable(){

                            @Override
                            public void run() {
                                NetworkUtils.updateActiveNetwork(BasicConfig.getInstance().getAppContext() != null ? BasicConfig.getInstance().getAppContext() : context);
                                if (NetworkUtils.isNetworkAvailable(context)) {
                                    sGetNetInfoRunnable = null;
                                    sRetryTimes = 0;
                                    sGetNetInfoRetryRunnable = null;
                                } else {
                                    sRetryTimes++;
                                    if (sRetryTimes < 4) {
                                        YYTaskExecutor.execute(sGetNetInfoRetryRunnable, 5000 + (sRetryTimes > 0 ? sRetryTimes * 5000 : 0));
                                    } else {
                                        sNetworkInfo = null;
                                        sGetNetInfoRunnable = null;
                                        sGetNetInfoRetryRunnable = null;
                                    }
                                }
                                NetworkInfo tmpNetworkInfo = sNetworkInfo;
                                if (tmpNetworkInfo != null) {
                                    MLog.info(NetworkUtils.TAG, "onNetConnectChanged retry:" + (tmpNetworkInfo.isConnected() || tmpNetworkInfo.isAvailable() && tmpNetworkInfo.isConnectedOrConnecting()), new Object[0]);
                                } else {
                                    MLog.info(NetworkUtils.TAG, "onNetConnectChanged:", new Object[0]);
                                }
                            }
                        };
                        YYTaskExecutor.execute(sGetNetInfoRetryRunnable, 5000 + (sRetryTimes > 0 ? sRetryTimes * 5000 : 0));
                    }
                    NetworkInfo tmpNetworkInfo = sNetworkInfo;
                    if (tmpNetworkInfo != null) {
                        MLog.info(NetworkUtils.TAG, "onNetConnectChanged:" + (tmpNetworkInfo.isConnected() || tmpNetworkInfo.isAvailable() && tmpNetworkInfo.isConnectedOrConnecting()), new Object[0]);
                    } else {
                        MLog.info(NetworkUtils.TAG, "onNetConnectChanged:", new Object[0]);
                    }
                }
            };
            YYTaskExecutor.execute(sGetNetInfoRunnable);
        } else {
            YYTaskExecutor.removeTask(sGetNetInfoRetryRunnable);
            YYTaskExecutor.removeTask(sGetNetInfoRunnable);
            YYTaskExecutor.execute(sGetNetInfoRunnable);
        }
    }

    private static void updateActiveNetwork(Context context) {
        if (context == null) {
            return;
        }
        sNetworkInfo = NetworkUtils.getActiveNetworkFromService(context);
    }

    private static String getLocalIpAddressFromService() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException ex) {
            MLog.error((Object)"NetworkUtils getLocalIpAddress:", ex.toString(), new Object[0]);
        }
        return null;
    }

    private static String getMacFromService(Context c) {
        try {
            WifiInfo connectionInfo;
            String macAddress = NetworkUtils.getMacAddrV23(c);
            if (!TextUtils.isEmpty((CharSequence)macAddress)) {
                return MD5Utils.getMD5String(macAddress);
            }
            WifiManager wifiMgr = (WifiManager)c.getSystemService(NET_NAME_WIFI);
            if (wifiMgr != null && (connectionInfo = wifiMgr.getConnectionInfo()) != null && (macAddress = connectionInfo.getMacAddress()) != null) {
                return MD5Utils.getMD5String(macAddress);
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, "getMac error! " + throwable, new Object[0]);
        }
        return "YY_FAKE_MAC";
    }

    public static String getLocalIpAddress() {
        if (sLocalIpAddress != null) {
            return sLocalIpAddress;
        }
        sLocalIpAddress = NetworkUtils.getLocalIpAddressFromService();
        return sLocalIpAddress;
    }

    public static String getMac(Context c) {
        if (sNetWorkApi != null) {
            return sNetWorkApi.getMac(c);
        }
        MLog.error((Object)TAG, "NetWorkApi not set before get mac", new Object[0]);
        return NetworkUtils.getMacByDefault(c);
    }

    private static String getMacByDefault(Context c) {
        if (sMac != null) {
            return sMac;
        }
        sMac = NetworkUtils.getMacFromService(c);
        return sMac;
    }

    public static String getWifiMacAddr(Context c) {
        if (sWifiMacAddr != null) {
            return sWifiMacAddr;
        }
        String macFromService = NetworkUtils.getMacFromService(c);
        sWifiMacAddr = "YY_FAKE_MAC".equals(macFromService) ? "" : macFromService;
        return sWifiMacAddr;
    }

    public static boolean isValidMac(String mac) {
        return !TextUtils.isEmpty((CharSequence)mac) && !mac.equalsIgnoreCase("02:00:00:00:00:00");
    }

    private static String getMacAddrV23(Context c) {
        String mac21;
        String mMacAddress = null;
        try {
            WifiManager mac2 = (WifiManager)c.getSystemService(NET_NAME_WIFI);
            if (mac2 != null) {
                WifiInfo connectionInfo = mac2.getConnectionInfo();
                mMacAddress = connectionInfo == null ? null : connectionInfo.getMacAddress();
            }
        }
        catch (Throwable var4) {
            MLog.error((Object)"getMacAddrV23", "exception on getMacAddr : %s", var4);
        }
        if (!NetworkUtils.isValidMac(mMacAddress) && NetworkUtils.isValidMac(mac21 = NetworkUtils.getMacAddr2())) {
            mMacAddress = mac21;
        }
        return mMacAddress;
    }

    @SuppressLint(value={"NewApi"})
    private static String getMacAddr2() {
        String address = null;
        try {
            if (Build.VERSION.SDK_INT >= 9) {
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (true) {
                    String var10;
                    byte[] by;
                    if (!e.hasMoreElements()) {
                        return address;
                    }
                    NetworkInterface netWork = e.nextElement();
                    if (!netWork.getName().equalsIgnoreCase("wlan0") || (by = netWork.getHardwareAddress()) == null || by.length == 0) continue;
                    StringBuilder builder = new StringBuilder();
                    byte[] mac = by;
                    int var6 = by.length;
                    for (int var7 = 0; var7 < var6; ++var7) {
                        byte b = mac[var7];
                        builder.append(String.format("%02X:", b));
                    }
                    if (builder.length() > 0) {
                        builder.deleteCharAt(builder.length() - 1);
                    }
                    address = var10 = builder.toString();
                }
            }
        }
        catch (Throwable var9) {
            MLog.error((Object)"getMacAddr2", "exception on getMacAddr2 : %s", var9);
        }
        return address;
    }

    public static Boolean isMobile(Context context) {
        NetworkInfo netInfo = NetworkUtils.getActiveNetwork(context);
        return netInfo != null && netInfo.getType() == 0;
    }

    static {
        mIpDnsInfo = new IpDnsInfo();
        sRetryTimes = 0;
    }

    public static class IpDnsInfo {
        private String mIP = "";
        private String mDNS = "";

        public void setIp(String ip) {
            this.mIP = ip;
        }

        public void setDns(String dns) {
            this.mDNS = dns;
        }

        public String getIp() {
            return this.mIP;
        }

        public String getDns() {
            return this.mDNS;
        }
    }

    public static class ChinaOperator {
        public static final String CMCC = "CMCC";
        public static final String CTL = "CTL";
        public static final String UNICOM = "UNICOM";
        public static final String UNKNOWN = "Unknown";
    }

    public static interface NetWorkApi {
        public String getMac(Context var1);
    }
}

