/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.style.ImageSpan;
import com.yy.mobile.util.log.MLog;

public class CustomImageSpan
extends ImageSpan {
    public static final int ALIGN_VERTICAL_CENTER = 2;
    public float mMarginLeft = 0.0f;
    public float mMarginRight = 0.0f;
    public float mMargin = 0.0f;

    public CustomImageSpan(Drawable d, int verticalAlignment, float marginLeft, float marginRight) {
        super(d, verticalAlignment);
        this.mMarginLeft = marginLeft;
        this.mMarginRight = marginRight;
    }

    public CustomImageSpan(Drawable d, int verticalAlignment, float margin) {
        super(d, verticalAlignment);
        this.mMargin = margin;
    }

    public CustomImageSpan(Drawable d, float marginLeft, float marginRight) {
        super(d, 2);
        this.mMarginLeft = marginLeft;
        this.mMarginRight = marginRight;
    }

    public CustomImageSpan(Drawable d, float margin) {
        super(d, 2);
        this.mMargin = margin;
    }

    public CustomImageSpan(Context context, int resourceId) {
        super(context, resourceId, 2);
    }

    public CustomImageSpan(Drawable d) {
        super(d, 2);
    }

    public CustomImageSpan(Drawable d, String source) {
        super(d, source, 2);
    }

    public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        if (this.mVerticalAlignment != 2) {
            return super.getSize(paint, text, start, end, fm);
        }
        Drawable d = this.getDrawable();
        if (d == null) {
            MLog.error((Object)"CustomImageSpan", "vivo7.1 crash protected", new Object[0]);
            return 0;
        }
        Rect rect = d.getBounds();
        if (fm != null) {
            Paint.FontMetricsInt fmPaint = paint.getFontMetricsInt();
            int fontHeight = fmPaint.bottom - fmPaint.top;
            int drHeight = rect.bottom - rect.top;
            int top = drHeight / 2 - fontHeight / 4;
            int bottom = drHeight / 2 + fontHeight / 4;
            fm.ascent = -bottom;
            fm.top = -bottom;
            fm.bottom = top;
            fm.descent = top;
        }
        if (this.mMarginLeft == 0.0f && this.mMarginRight == 0.0f) {
            return (int)((float)rect.right + this.mMargin * 2.0f);
        }
        return (int)((float)rect.right + this.mMarginLeft + this.mMarginRight);
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        if (this.mVerticalAlignment != 2) {
            super.draw(canvas, text, start, end, x, top, y, bottom, paint);
            return;
        }
        Drawable d = this.getDrawable();
        if (d == null) {
            return;
        }
        canvas.save();
        if (this.mMarginLeft == 0.0f && this.mMarginRight == 0.0f) {
            x += this.mMargin;
        }
        float transY = (float)(bottom - top - d.getBounds().bottom) / 2.0f + (float)top;
        canvas.translate(x += this.mMarginLeft, transY);
        if (d instanceof BitmapDrawable) {
            BitmapDrawable drawable2 = (BitmapDrawable)d;
            if (drawable2.getBitmap() != null && !drawable2.getBitmap().isRecycled()) {
                d.draw(canvas);
            }
        } else {
            d.draw(canvas);
        }
        canvas.restore();
    }
}

