/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.text.format.Time;
import com.yy.mobile.util.CommonUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final String FORMAT_ONE = "yyyy-MM-dd HH:mm:ss";
    private static long TEN_MINUTES = 600000L;

    public static Date stringtoDate(String dateStr, String format) {
        Date d = null;
        SimpleDateFormat formater = DateUtils.getSimpleDateFormat(format);
        try {
            formater.setLenient(false);
            d = formater.parse(dateStr);
        }
        catch (Exception e) {
            d = null;
        }
        return d;
    }

    public static String dateToString(Date date, String format) {
        String result = "";
        SimpleDateFormat formater = DateUtils.getSimpleDateFormat(format);
        try {
            result = formater.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static long timeSub(String firstTime, String secTime) {
        if (firstTime == null || firstTime.equals("")) {
            return 0L;
        }
        if (secTime == null || secTime.equals("")) {
            return 0L;
        }
        long first = DateUtils.stringtoDate(firstTime, FORMAT_ONE).getTime();
        long second = DateUtils.stringtoDate(secTime, FORMAT_ONE).getTime();
        return (first - second) / 1000L;
    }

    public static String getNow() {
        Calendar today = Calendar.getInstance();
        return DateUtils.dateToString(today.getTime(), FORMAT_ONE);
    }

    public static String convertTime(long predictTime) {
        Time time = new Time();
        time.set(predictTime);
        int theYear = time.year;
        int theMonth = time.month;
        int theMonthDay = time.monthDay;
        long curTime = System.currentTimeMillis();
        time.set(curTime);
        String formatTime = theYear == time.year && theMonth == time.month ? (theMonthDay == time.monthDay ? (predictTime - curTime < TEN_MINUTES ? "\u5373\u5c06\u5f00\u59cb" : "\u4eca\u5929  " + DateUtils.dateToString(new Date(predictTime), "HH:mm")) : (theMonthDay == time.monthDay + 1 ? "\u660e\u5929  " + DateUtils.dateToString(new Date(predictTime), "HH:mm") : DateUtils.dateToString(new Date(predictTime), "M\u6708d\u65e5 HH:mm"))) : DateUtils.dateToString(new Date(predictTime), "M\u6708d\u65e5 HH:mm");
        return formatTime;
    }

    public static boolean isTomorrow(Calendar cal, long preTime) {
        Calendar mintianday = Calendar.getInstance();
        mintianday.set(1, cal.get(1));
        mintianday.set(2, cal.get(2));
        mintianday.set(5, cal.get(5) + 1);
        Calendar pre = Calendar.getInstance();
        pre.setTime(new Date(preTime));
        if (pre.get(5) != mintianday.get(5)) {
            return false;
        }
        if (pre.get(2) != mintianday.get(2)) {
            return false;
        }
        return pre.get(1) == mintianday.get(1);
    }

    public static boolean isToday(Calendar cal, long preTime) {
        Calendar pre = Calendar.getInstance();
        pre.setTime(new Date(preTime));
        if (pre.get(5) != cal.get(5)) {
            return false;
        }
        if (pre.get(2) != cal.get(2)) {
            return false;
        }
        return pre.get(1) == cal.get(1);
    }

    public static boolean isYesterday(Calendar cal, long preTime) {
        Calendar mintianday = Calendar.getInstance();
        mintianday.set(1, cal.get(1));
        mintianday.set(2, cal.get(2));
        mintianday.set(5, cal.get(5) - 1);
        Calendar pre = Calendar.getInstance();
        pre.setTime(new Date(preTime));
        if (pre.get(5) != mintianday.get(5)) {
            return false;
        }
        if (pre.get(2) != mintianday.get(2)) {
            return false;
        }
        return pre.get(1) == mintianday.get(1);
    }

    public static SimpleDateFormat getSimpleDateFormat(String format) {
        return CommonUtils.getSimpleDateFormat(format);
    }

    public static String formatTime(Long ms) {
        Integer ss = 1000;
        Integer mi = ss * 60;
        Integer hh = mi * 60;
        Integer dd = hh * 24;
        Long day = ms / (long)dd.intValue();
        Long hour = (ms - day * (long)dd.intValue()) / (long)hh.intValue();
        Long minute = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue()) / (long)mi.intValue();
        Long second = (ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue()) / (long)ss.intValue();
        Long milliSecond = ms - day * (long)dd.intValue() - hour * (long)hh.intValue() - minute * (long)mi.intValue() - second * (long)ss.intValue();
        StringBuffer sb = new StringBuffer();
        if (day > 0L) {
            sb.append(day + "\u5929");
        }
        if (hour > 0L) {
            sb.append(hour + "\u5c0f\u65f6");
        }
        if (minute > 0L) {
            sb.append(minute + "\u5206");
        }
        if (second > 0L) {
            sb.append(second + "\u79d2");
        }
        if (milliSecond > 0L) {
            sb.append(milliSecond + "\u6beb\u79d2");
        }
        return sb.toString();
    }

    public static int getDaysByTwoMillisecond(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    public static boolean getIsMoreDayByTwoMillisecond(Long date1, Long date2) {
        long sum = 86400000L;
        return date2 - date1 > sum;
    }

    public static String getImMsgFormatTime(long msgTime) {
        Calendar c = Calendar.getInstance();
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        int y1 = c.get(1);
        Date today = c.getTime();
        long diff = today.getTime() - msgTime;
        if (diff < 0L) {
            diff = 0L;
        }
        long days = diff / 86400000L;
        c.clear();
        c.setTimeInMillis(msgTime);
        int y2 = c.get(1);
        SimpleDateFormat format = days == 0L ? CommonUtils.getSimpleDateFormat("HH:mm") : (y1 != y2 ? CommonUtils.getSimpleDateFormat("yyyy\u5e74M\u6708d\u65e5") : CommonUtils.getSimpleDateFormat("M\u6708d\u65e5"));
        return format.format(c.getTime());
    }

    public static String getGreetMsgFormatTime(long msgTime) {
        Calendar c = Calendar.getInstance();
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        int y1 = c.get(1);
        Date today = c.getTime();
        long diff = today.getTime() - msgTime;
        if (diff < 0L) {
            diff = 0L;
        }
        long days = diff / 86400000L;
        c.clear();
        c.setTimeInMillis(msgTime);
        int y2 = c.get(1);
        SimpleDateFormat format = days == 0L ? CommonUtils.getSimpleDateFormat("H:mm") : (y1 != y2 ? CommonUtils.getSimpleDateFormat("yyyy-M-dd") : CommonUtils.getSimpleDateFormat("M-dd"));
        return format.format(c.getTime());
    }
}

