/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import com.yy.mobile.framework.R;
import com.yy.mobile.richtext.BaseRichTextFilter;
import com.yy.mobile.richtext.ChannelTicketFilter;
import com.yy.mobile.richtext.EmoticonFilter;
import com.yy.mobile.richtext.YGroupTicketFilter;
import com.yy.mobile.richtext.media.ImVoiceFilter;
import com.yy.mobile.richtext.media.ImageFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RichTextManager {
    private Map<Feature, BaseRichTextFilter> filterMap = new HashMap<Feature, BaseRichTextFilter>();
    private static RichTextManager instance;

    public static synchronized RichTextManager getInstance() {
        if (instance == null) {
            instance = new RichTextManager();
        }
        return instance;
    }

    public RichTextManager() {
        this.filterMap.put(Feature.IMAGE, new ImageFilter());
        this.filterMap.put(Feature.CHANNELAIRTICKET, new ChannelTicketFilter(R.drawable.feijipiao_bg));
        this.filterMap.put(Feature.GROUPTICKET, new YGroupTicketFilter(R.drawable.feijipiao_bg));
        this.filterMap.put(Feature.EMOTICON, new EmoticonFilter());
        this.filterMap.put(Feature.VOICE, new ImVoiceFilter());
    }

    public void addFilterFeature(BaseRichTextFilter filter) {
        this.filterMap.put(Feature.NOBLEEMOTION, filter);
    }

    public BaseRichTextFilter getFilterFeature(Feature feature) {
        return this.filterMap.get((Object)feature);
    }

    public void addGifFilterFeature(BaseRichTextFilter filter) {
        this.filterMap.put(Feature.NOBLEGIFEMOTION, filter);
    }

    public void removeGifFilterFeature() {
        this.filterMap.remove((Object)Feature.NOBLEGIFEMOTION);
    }

    public Spannable getSpannableString(Context context, CharSequence charSequence, List<Feature> featureList) {
        Object spannable = charSequence instanceof Spannable ? (Spannable)charSequence : new SpannableString(charSequence);
        for (Feature feature : featureList) {
            BaseRichTextFilter filter = this.filterMap.get((Object)feature);
            if (filter == null) continue;
            filter.parseSpannable(context, (Spannable)spannable, Integer.MAX_VALUE);
        }
        return spannable;
    }

    public Spannable getSpannableString(Context context, CharSequence charSequence, List<Feature> featureList, int normalWidth) {
        Object spannable = charSequence instanceof Spannable ? (Spannable)charSequence : new SpannableString(charSequence);
        for (Feature feature : featureList) {
            BaseRichTextFilter filter = this.filterMap.get((Object)feature);
            if (filter == null) continue;
            filter.parseSpannable(context, (Spannable)spannable, normalWidth > 0 ? normalWidth : Integer.MAX_VALUE, normalWidth);
        }
        return spannable;
    }

    public void filterAll(Context context, CharSequence charSequence, int maxWidth) {
        this.filterAll(context, charSequence, maxWidth, null);
    }

    public void filterAll(Context context, CharSequence charSequence, int maxWidth, Object tag) {
        Object spannable = charSequence instanceof Spannable ? (Spannable)charSequence : new SpannableString(charSequence);
        for (Map.Entry<Feature, BaseRichTextFilter> entry : this.filterMap.entrySet()) {
            BaseRichTextFilter filter = entry.getValue();
            if (maxWidth <= 0) {
                maxWidth = Integer.MAX_VALUE;
            }
            if (tag == null) {
                filter.parseSpannable(context, (Spannable)spannable, maxWidth);
                continue;
            }
            filter.parseSpannable(context, (Spannable)spannable, maxWidth, tag);
        }
    }

    public void setSpanClickListener(Feature feature, BaseRichTextFilter.OnSpanClickListener listener) {
        this.setSpanClickListener(feature, listener, "");
    }

    public void setSpanClickListener(Feature feature, BaseRichTextFilter.OnSpanClickListener listener, String currentContext) {
        BaseRichTextFilter filter = this.filterMap.get((Object)feature);
        if (filter != null) {
            filter.setSpanClickListener(listener, currentContext);
        }
    }

    public void clearSpanClickListener(Feature feature) {
        this.clearSpanClickListener(feature, "");
    }

    public void clearSpanClickListener(Feature feature, String currentContext) {
        BaseRichTextFilter filter = this.filterMap.get((Object)feature);
        if (filter != null) {
            filter.clearSpanClickListener(currentContext);
        }
    }

    public static enum Feature {
        EMOTICON(0),
        CHANNELAIRTICKET(1),
        GROUPTICKET(2),
        IMAGE(3),
        VOICE(4),
        VIPEMOTICON(5),
        NUMBER(6),
        NOBLEEMOTION(7),
        NOBLEGIFEMOTION(8);

        private int value;

        private Feature(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

