/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.text.style.ImageSpan;
import android.view.View;
import com.yy.mobile.richtext.BaseRichTextFilter;
import com.yy.mobile.util.log.MLog;

public abstract class AirTicketFilter
extends BaseRichTextFilter {
    public static final String TAG = "AirTicketFilter";
    protected Drawable ticketDrawable;
    private final int resId;

    public AirTicketFilter(int id2) {
        this.resId = id2;
    }

    protected Drawable getTicketDrawable(Context context) {
        if (context == null) {
            MLog.info(TAG, "getTicketDrawable context:null", new Object[0]);
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.resId);
        if (bitmap == null) {
            MLog.info(TAG, "getTicketDrawable bitmap:null", new Object[0]);
            return null;
        }
        byte[] chunk = bitmap.getNinePatchChunk();
        if (chunk == null || chunk.length == 0) {
            MLog.info(TAG, "getTicketDrawable chunk:null", new Object[0]);
            return null;
        }
        this.ticketDrawable = new NinePatchDrawable(context.getResources(), bitmap, chunk, null, null);
        int width = this.ticketDrawable.getIntrinsicWidth();
        int height = this.ticketDrawable.getIntrinsicHeight();
        this.ticketDrawable.setBounds(0, 0, width > 0 ? width : 0, height > 0 ? height : 0);
        return this.ticketDrawable;
    }

    public class TicketClickSpan
    extends ClickableSpan {
        public void onClick(View view) {
            if (AirTicketFilter.this.mOnSpanClickListener != null) {
                AirTicketFilter.this.mOnSpanClickListener.onClick(view, (Object)this);
            }
        }
    }

    public class AirTicketSpan
    extends ImageSpan {
        String content;
        private int maxWidth;

        public AirTicketSpan(Drawable drawable2, String text) {
            super(drawable2);
            this.maxWidth = Integer.MAX_VALUE;
            this.content = text;
        }

        public AirTicketSpan(Drawable drawable2, String text, int maxWidth) {
            super(drawable2);
            this.maxWidth = Integer.MAX_VALUE;
            this.content = text;
            this.maxWidth = maxWidth;
        }

        public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
            Drawable d = this.getDrawable();
            Rect rect = d.getBounds();
            if (fm != null) {
                fm.ascent = -rect.bottom;
                fm.descent = 0;
                fm.top = fm.ascent;
                fm.bottom = 0;
            }
            int width = rect.width();
            int height = rect.height();
            float textWidth = paint.measureText(this.content);
            width = Math.max(width, (int)(textWidth + (float)(width / 3) + 30.0f));
            width = Math.min(width, this.maxWidth);
            d.setBounds(0, 0, width, height);
            return width;
        }

        public void updateMeasureState(TextPaint p) {
            super.updateMeasureState(p);
        }

        public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
            Paint.FontMetricsInt fm = paint.getFontMetricsInt();
            float textHeight = (float)Math.ceil(fm.descent - fm.ascent);
            float textWidth = paint.measureText(this.content);
            Drawable drawable2 = this.getDrawable();
            Rect rect = drawable2.getBounds();
            int width = rect.width();
            int height = rect.height();
            float textX = x + (float)(width / 3);
            float textY = (float)top + textHeight + (float)fm.descent;
            super.draw(canvas, text, start, end, x, top, y, bottom, paint);
            canvas.save();
            canvas.translate(textX, textY);
            paint.setColor(-11430698);
            paint.setUnderlineText(true);
            canvas.drawText(this.content, 0.0f, 0.0f, paint);
            canvas.restore();
        }
    }
}

