/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.cache;

import android.content.Context;
import com.yy.mobile.cache.CacheClient;
import com.yy.mobile.cache.NoSuchKeyException;
import com.yy.mobile.cache.StringDiskCache;
import com.yy.mobile.cache.StringLruCache;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.DiskCache;
import com.yy.mobile.util.MD5Utils;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CacheManager {
    private static final String TAG = "CacheManager";
    private static CacheManager mInstance = null;
    private static final int MEM_MAX_SIZE = 0x100000;
    private StringLruCache<String, String> mMemoryCache = null;
    private static final int DISK_MAX_SIZE = 0x500000;
    private static final String cachePath = "cacheDir";
    private StringDiskCache mDiskCacke = null;
    private Context mContext = BasicConfig.getInstance().getAppContext();

    public CacheManager(String fileName) {
        this.mMemoryCache = new StringLruCache<String, String>(0x100000){

            @Override
            protected int sizeOf(String key, String value) {
                int count = value.getBytes().length;
                return count;
            }

            @Override
            protected void entryRemoved(boolean evicted, String key, String oldValue, String newValue) {
                super.entryRemoved(evicted, key, oldValue, newValue);
            }
        };
        File cacheDir = DiskCache.getCacheDir(this.mContext, cachePath + File.separator + fileName);
        this.mDiskCacke = StringDiskCache.openCache(cacheDir, 0x500000L);
    }

    public boolean putCache(String key, String json, long expire) {
        String md5Key = MD5Utils.getMD5String(key);
        if (this.mDiskCacke != null) {
            MLog.info(TAG, "put json to SD key = " + key, new Object[0]);
            this.mDiskCacke.putText(md5Key, json);
        }
        if (this.mMemoryCache != null) {
            MLog.info(TAG, "put json to Memory key = " + key, new Object[0]);
            this.mMemoryCache.put(md5Key, json);
        }
        return false;
    }

    public String getCache(String key) throws NoSuchKeyException, IOException {
        if (BlankUtil.isBlank(key)) {
            return null;
        }
        String md5Key = MD5Utils.getMD5String(key);
        String json = "";
        if (this.mMemoryCache != null && (json = this.mMemoryCache.get(md5Key)) != null) {
            CacheClient.CachePacket packet = JsonParser.parseJsonObject(json, CacheClient.CachePacket.class);
            long expiredTime = System.currentTimeMillis() - packet.getHeader().getCreateTime();
            if (expiredTime > packet.getHeader().getExpired()) {
                this.remove(key);
                return null;
            }
            MLog.info(TAG, "get Json from mem: key = " + key, new Object[0]);
            return json;
        }
        if (this.mDiskCacke != null) {
            try {
                json = this.mDiskCacke.get(md5Key);
                if (json != null) {
                    this.mMemoryCache.put(md5Key, json);
                    MLog.info(TAG, "get Json from sd: key = " + key, new Object[0]);
                    return json;
                }
            }
            catch (FileNotFoundException e) {
                throw new NoSuchKeyException(key, "no such key");
            }
            catch (IOException e) {
                throw e;
            }
        }
        return null;
    }

    public void remove(String key, String path) {
        if (BlankUtil.isBlank(key)) {
            return;
        }
        String md5Key = MD5Utils.getMD5String(key);
        if (this.mMemoryCache != null) {
            this.mMemoryCache.remove(md5Key);
        }
        if (this.mDiskCacke != null) {
            this.mDiskCacke.clearCache(md5Key);
        }
    }

    public void remove(String key) {
        if (BlankUtil.isBlank(key)) {
            return;
        }
        String md5Key = MD5Utils.getMD5String(key);
        if (this.mMemoryCache != null) {
            this.mMemoryCache.remove(md5Key);
        }
        if (this.mDiskCacke != null) {
            this.mDiskCacke.clearCache(md5Key);
        }
    }

    public void clear() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
        }
        if (this.mDiskCacke != null) {
            this.mDiskCacke.clearCache();
        }
    }
}

