/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import com.yy.mobile.util.Base64Utils;

public class RC4Utils {
    public static String encrypt(String s, String key) throws Exception {
        if (s == null || s.length() == 0 || key == null || key.length() == 0) {
            return null;
        }
        return RC4Utils.encrypt(s.getBytes(), key);
    }

    public static String encrypt(byte[] input, String key) throws Exception {
        if (input == null || input.length == 0 || key == null || key.length() == 0) {
            return null;
        }
        RC4 encryptHelper = new RC4(key.getBytes());
        encryptHelper.doFinal(input);
        return Base64Utils.encodeToString(input, 2);
    }

    public static String decrypt(String s, String key) throws Exception {
        if (s == null || s.length() == 0 || key == null || key.length() == 0) {
            return null;
        }
        return RC4Utils.decrypt(s.getBytes(), key);
    }

    public static String decrypt(byte[] input, String key) throws Exception {
        if (input == null || input.length == 0 || key == null || key.length() == 0) {
            return null;
        }
        RC4 decryptHelper = new RC4(key.getBytes());
        input = Base64Utils.decode(input, 2);
        decryptHelper.doFinal(input);
        return new String(input);
    }

    public static class RC4 {
        private static final int STATE_LENGTH = 256;
        private byte[] engineState = null;
        private int x = 0;
        private int y = 0;
        private byte[] workingKey = null;

        public RC4(byte[] key) {
            this.setKey(key);
        }

        public void setKey(byte[] key) {
            if (key == null || key.length == 0) {
                return;
            }
            this.workingKey = new byte[key.length];
            System.arraycopy(key, 0, this.workingKey, 0, key.length);
            this.x = 0;
            this.y = 0;
            if (this.engineState == null) {
                this.engineState = new byte[256];
            }
            for (int i = 0; i < 256; ++i) {
                this.engineState[i] = (byte)i;
            }
            int i1 = 0;
            int i2 = 0;
            for (int i = 0; i < 256; ++i) {
                i2 = (key[i1] & 0xFF) + this.engineState[i] + i2 & 0xFF;
                byte tmp = this.engineState[i];
                this.engineState[i] = this.engineState[i2];
                this.engineState[i2] = tmp;
                i1 = (i1 + 1) % key.length;
            }
        }

        public void doFinal(byte[] input) {
            this.doFinal(input, 0, input.length);
        }

        private void doFinal(byte[] input, int start, int count) {
            if (input == null || start < 0 || count < 0) {
                return;
            }
            for (int i = start; i < start + count; ++i) {
                this.x = this.x + 1 & 0xFF;
                this.y = this.engineState[this.x] + this.y & 0xFF;
                byte tmp = this.engineState[this.x];
                this.engineState[this.x] = this.engineState[this.y];
                this.engineState[this.y] = tmp;
                input[i] = (byte)(input[i] ^ this.engineState[this.engineState[this.x] + this.engineState[this.y] & 0xFF]);
            }
        }

        public void reset() {
            this.setKey(this.workingKey);
        }
    }
}

