/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    private static final String TAG = "MD5Utils";
    protected static MessageDigest messagedigest = null;

    public static String fileMd5(String filePath) {
        if (StringUtils.isNullOrEmpty(filePath)) {
            return "";
        }
        try {
            return MD5Utils.getFileMd5String(filePath);
        }
        catch (Exception e) {
            MLog.warn(TAG, "get file [%s] md5 error", filePath);
            return "";
        }
    }

    public static String fileMd5(File file) {
        if (file == null) {
            return "";
        }
        try {
            return MD5Utils.getFileMD5String(file);
        }
        catch (Exception e) {
            MLog.warn(TAG, "get file [%s] md5 error", file.getAbsoluteFile());
            return "";
        }
    }

    public static String getFileMd5String(String path) throws IOException {
        if (path == null || path.length() == 0) {
            return null;
        }
        File big = new File(path);
        return MD5Utils.getFileMD5String(big);
    }

    public static String getFileMD5String(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        String md5 = null;
        FileInputStream in = new FileInputStream(file);
        if (messagedigest != null) {
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                messagedigest.update(buffer, 0, len);
            }
            md5 = MD5Utils.bufferToHex(messagedigest.digest());
        }
        in.close();
        return md5;
    }

    public static String getMD5String(String s) {
        if (s == null) {
            return null;
        }
        return MD5Utils.getMD5String(s.getBytes());
    }

    public static String getMD5String(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String md5 = null;
        try {
            if (messagedigest != null) {
                messagedigest.update(bytes);
                md5 = MD5Utils.bufferToHex(messagedigest.digest());
            }
        }
        catch (Throwable ex) {
            MLog.error(TAG, ex);
        }
        return md5;
    }

    private static String bufferToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return MD5Utils.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int start, int len) {
        if (bytes == null || start < 0 || len < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * len);
        int max = start + len;
        for (int i = start; i < max; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            stringBuilder.append(hex);
        }
        return stringBuilder.toString();
    }

    static {
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            MLog.error((Object)TAG, "get message digest failed! " + e.toString(), new Object[0]);
        }
    }
}

