/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.statistic;

import android.os.Build;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.guid.GuidFactory;
import com.yy.mobile.statistic.AbstractReportProperty;
import com.yy.mobile.statistic.StatisticDataModelBase;
import com.yy.mobile.statistic.StatisticNewDataContainer;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;

public class StatisticVideoDataContainer
extends StatisticNewDataContainer {
    private static final String TAG = "StatisticVideoDataContainer";

    @Override
    public String getAsJson(Object context, AbstractReportProperty reportProperty) {
        if (context == null || FP.empty(this.dataList)) {
            return null;
        }
        try {
            Gson gson = this.mGsonBuilder.create();
            JsonObject jsonObject = new JsonObject();
            ArrayList<StatisticDataModelBase> list = new ArrayList<StatisticDataModelBase>();
            for (StatisticDataModelBase item : this.dataList) {
                if (item.isReporting) continue;
                item.reportContext = context;
                item.isReporting = true;
                list.add(item);
            }
            if (list.size() > 0) {
                jsonObject.add("playload", gson.toJsonTree(list));
            }
            if (gson.toJson((JsonElement)jsonObject).equals("{}")) {
                return null;
            }
            jsonObject.addProperty("ns", "videoperf.mob");
            jsonObject.addProperty("platform", "android");
            jsonObject.addProperty("yyplatform", VersionUtil.getLocalVer(BasicConfig.getInstance().getAppContext()).toString());
            jsonObject.addProperty("sid", GuidFactory.getInstance().getGuid());
            jsonObject.addProperty("sysversion", "Android" + Build.VERSION.RELEASE);
            jsonObject.addProperty("time", (Number)System.currentTimeMillis());
            jsonObject.addProperty("device", Build.MANUFACTURER + "_" + Build.MODEL);
            return gson.toJson((JsonElement)jsonObject);
        }
        catch (Exception e) {
            MLog.error(TAG, e);
            return null;
        }
    }
}

