/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.mobile.http.dns.GslbDns;
import com.yy.mobile.http.dnsparser.DnsParser;
import com.yy.mobile.util.log.MLog;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Dns;

public class OkHttpDns
implements Dns {
    private static final String Tag = "OkHttpDns";
    private static OkHttpDns instance = null;

    private OkHttpDns() {
    }

    public static OkHttpDns getInstance() {
        if (instance == null) {
            instance = new OkHttpDns();
        }
        MLog.info(Tag, "getInstance", new Object[0]);
        return instance;
    }

    public List<InetAddress> lookup(String hostname) throws UnknownHostException {
        List<String> info;
        MLog.info(Tag, "lookup getByName.hostname:" + hostname, new Object[0]);
        if (DnsParser.needsConvertOnly(hostname) && (info = GslbDns.inst().getIps(hostname)) != null && info.size() > 0) {
            ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>();
            for (int i = 0; i < info.size(); ++i) {
                InetAddress addr = InetAddress.getByName(info.get(i));
                inetAddresses.add(addr);
            }
            return inetAddresses;
        }
        return Dns.SYSTEM.lookup(hostname);
    }
}

