/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.file.data;

import android.os.Build;
import android.os.Environment;
import com.yy.mobile.file.BaseFileRequest;
import com.yy.mobile.file.FileRequestException;
import com.yy.mobile.file.NoExternalStorageException;
import com.yy.mobile.file.data.FileDataParam;
import com.yy.mobile.http.ByteArrayPool;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class BaseFileDataRequest<T>
extends BaseFileRequest<T> {
    public static final int DEFAULT_POOL_SIZE = 4096;
    protected static final ByteArrayPool sBytePool = new ByteArrayPool(4096);
    protected final Object mSync = new Object();
    protected File mDataDir;
    protected FileDataParam mDataConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDataDir() throws FileRequestException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDataDir == null) {
                this.mDataDir = BaseFileDataRequest.createOrGetDataDir(this.mDataConfig.getDataDir());
            }
            return this.mDataDir;
        }
    }

    public File getDataFile(String name) throws FileRequestException {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose("FileRequest", "Data file key=" + name, new Object[0]);
        }
        return this.makeFilename(this.getDataDir(), name);
    }

    protected File makeFilename(File base, String name) {
        return new File(base, this.getFilenameForKey(name));
    }

    protected static byte[] streamToBytes(InputStream in, int length) throws IOException {
        int pos;
        int count;
        byte[] bytes = sBytePool.getBuf(length);
        for (pos = 0; pos < length && (count = in.read(bytes, pos, length - pos)) != -1; pos += count) {
        }
        if (pos != length) {
            throw new IOException("Expected " + length + " bytes, read " + pos + " bytes");
        }
        return bytes;
    }

    protected String getFilenameForKey(String key) {
        int firstHalfLength = key.length() / 2;
        String localFilename = String.valueOf(key.substring(0, firstHalfLength).hashCode());
        localFilename = localFilename + String.valueOf(key.substring(firstHalfLength).hashCode());
        return localFilename;
    }

    public static File createOrGetDataDir(String uniqueName) throws NoExternalStorageException {
        if ("mounted".equals(Environment.getExternalStorageState()) || !BaseFileDataRequest.isExternalStorageRemovable()) {
            String cachePath = BaseFileDataRequest.getExternalCacheDir().getPath();
            File dir = new File(cachePath + File.separator + uniqueName);
            if (dir != null && !dir.exists() && !dir.mkdirs()) {
                MLog.error((Object)"FileRequest", "Can't create data dir : %s", dir.getAbsolutePath());
                throw new NoExternalStorageException();
            }
            return dir;
        }
        throw new NoExternalStorageException();
    }

    protected static boolean isExternalStorageRemovable() {
        if (Build.VERSION.SDK_INT >= 9) {
            return Environment.isExternalStorageRemovable();
        }
        return true;
    }

    protected static File getExternalCacheDir() {
        return new File(Environment.getExternalStorageDirectory().getPath());
    }
}

