/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.taskexecutor;

import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.Process;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.HandlEx;
import com.yy.mobile.util.taskexecutor.IQueueTaskExecutor;
import com.yy.mobile.util.taskexecutor.Prioritized;
import com.yy.mobile.util.taskexecutor.ReflectionHelper;
import com.yy.mobile.util.taskexecutor.RuntimeCompat;
import com.yy.mobile.util.taskexecutor.YYTaskExecutorHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

public class YYTaskExecutor {
    private static final String TAG = "YYTaskExecutor";
    public static final int THREAD_PRIORITY_LOW = 14;
    public static final int THREAD_PRIORITY_BACKGROUND = 10;
    public static final int THREAD_WORK_PRIORITY = 5;
    public static final int THREAD_PRIORITY_NORMAL = 5;
    public static final int THREAD_PRIORITY_HIGH = 0;
    private static final int CORE_SIZE = RuntimeCompat.calculateBestThreadCount();
    private static ThreadPoolExecutor sThreadPool = YYTaskExecutorHelper.INSTANCE.getComputePool();
    private static ThreadPoolExecutor sIOThreadPool = YYTaskExecutorHelper.INSTANCE.getIOThreadPool();
    private static ScheduledExecutorService sGiftThreadPool = YYTaskExecutorHelper.INSTANCE.getGiftSinglePool();
    private static volatile HandlEx sMainThreadHandler;
    private static final HashMap<Runnable, Runnable> sDelayExecutorRunnableCache;
    private static final HashMap<Runnable, Runnable> sExecutorRunnableCache;
    private static final HashMap<Runnable, CustomIdelHandler> sMainThreadIdelRunnableCache;
    private static Thread sMainThread;

    public static void execute(Runnable task) {
        YYTaskExecutor.execute(task, 0L);
    }

    public static void execute(Runnable task, TaskType taskType) {
        YYTaskExecutor.execute(task, 0L, 10, taskType);
    }

    public static void execute(Runnable task, long delayMillis) {
        YYTaskExecutor.execute(task, null, delayMillis, 10, TaskType.NORMAL);
    }

    public static void execute(Runnable task, long delayMillis, int priority) {
        YYTaskExecutor.execute(task, null, delayMillis, priority, TaskType.NORMAL);
    }

    public static void execute(Runnable task, long delayMillis, int priority, TaskType taskType) {
        YYTaskExecutor.execute(task, null, delayMillis, priority, taskType);
    }

    public static void execute(Runnable task, Runnable callbackInMainThread, long delayMillis) {
        YYTaskExecutor.execute(task, callbackInMainThread, delayMillis, 10, TaskType.NORMAL);
    }

    public static void execute(Runnable task, Runnable callbackInMainThread) {
        YYTaskExecutor.execute(task, callbackInMainThread, 0L);
    }

    public static void execute(Runnable task, Runnable callbackInMainThread, long delayMillis, int thePriority) {
        YYTaskExecutor.execute(task, callbackInMainThread, delayMillis, thePriority, TaskType.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(final Runnable task, Runnable callbackInMainThread, long delayMillis, int thePriority, TaskType taskType) {
        if (task == null) {
            return;
        }
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        if (thePriority < 0) {
            thePriority = 10;
        } else if (thePriority > 0) {
            thePriority = 0;
        }
        int priority = thePriority;
        ExecutorRunnable theExecutorRunnable = ExecutorRunnable.obtain();
        if (theExecutorRunnable == null) {
            theExecutorRunnable = new ExecutorRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Process.setThreadPriority((int)10);
                        HashMap hashMap = sExecutorRunnableCache;
                        synchronized (hashMap) {
                            sExecutorRunnableCache.remove(this.task);
                        }
                        this.task.run();
                        if (this.callBack != null) {
                            YYTaskExecutor.getMainThreadHandler().post(this.callBack);
                        }
                    }
                    catch (Throwable t) {
                        HashMap hashMap = sExecutorRunnableCache;
                        synchronized (hashMap) {
                            sExecutorRunnableCache.remove(this.task);
                        }
                        MLog.error("YYTaskExecutor execute error one:", t);
                        if (BasicConfig.getInstance().isDebuggable()) {
                            YYTaskExecutor.getMainThreadHandler().post(new Runnable(){

                                @Override
                                public void run() {
                                    throw new RuntimeException(YYTaskExecutor.getStackTraceString(t), t);
                                }
                            });
                        }
                    }
                    finally {
                        if (this.priority != 10) {
                            try {
                                Process.setThreadPriority((int)10);
                            }
                            catch (Throwable t) {
                                Log.e((String)YYTaskExecutor.TAG, (String)(" error ignore: " + t.getMessage()));
                            }
                        }
                        this.recycle();
                    }
                }
            };
        }
        final ExecutorRunnable executorRunnable = theExecutorRunnable;
        executorRunnable.taskType = taskType.ordinal();
        executorRunnable.task = task;
        executorRunnable.callBack = callbackInMainThread;
        executorRunnable.priority = priority;
        if (delayMillis > 0L) {
            Runnable delayDelayExecutorRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashMap hashMap = sDelayExecutorRunnableCache;
                    synchronized (hashMap) {
                        sDelayExecutorRunnableCache.remove(task);
                    }
                    YYTaskExecutor.execute(executorRunnable);
                }
            };
            HashMap<Runnable, Runnable> hashMap = sDelayExecutorRunnableCache;
            synchronized (hashMap) {
                sDelayExecutorRunnableCache.put(task, delayDelayExecutorRunnable);
            }
            YYTaskExecutor.postToMainThread(delayDelayExecutorRunnable, delayMillis);
        } else {
            YYTaskExecutor.execute(executorRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(ExecutorRunnable task) {
        block15: {
            if (task == null || task.task == null) {
                return;
            }
            try {
                if (task.taskType == 0) {
                    if (sThreadPool.isShutdown()) break block15;
                    HashMap<Runnable, Runnable> hashMap = sExecutorRunnableCache;
                    synchronized (hashMap) {
                        sExecutorRunnableCache.put(task.task, task);
                    }
                    sThreadPool.execute(task);
                    break block15;
                }
                if (task.taskType == 2) {
                    if (sGiftThreadPool.isShutdown()) break block15;
                    HashMap<Runnable, Runnable> hashMap = sExecutorRunnableCache;
                    synchronized (hashMap) {
                        sExecutorRunnableCache.put(task.task, task);
                    }
                    sGiftThreadPool.execute(task);
                    break block15;
                }
                if (sIOThreadPool.isShutdown()) break block15;
                HashMap<Runnable, Runnable> hashMap = sExecutorRunnableCache;
                synchronized (hashMap) {
                    sExecutorRunnableCache.put(task.task, task);
                }
                sIOThreadPool.execute(task);
            }
            catch (Throwable e) {
                if (BasicConfig.getInstance().isDebuggable()) {
                    YYTaskExecutor.getMainThreadHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            throw new RuntimeException(YYTaskExecutor.getStackTraceString(e), e);
                        }
                    });
                }
                MLog.error("YYTaskExecutor execute error two:", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTask(Runnable task) {
        Runnable executorRunnable;
        Runnable delayExecutorRunnable;
        if (task == null) {
            return;
        }
        HashMap<Runnable, Runnable> hashMap = sDelayExecutorRunnableCache;
        synchronized (hashMap) {
            delayExecutorRunnable = sDelayExecutorRunnableCache.remove(task);
        }
        if (delayExecutorRunnable != null) {
            YYTaskExecutor.getMainThreadHandler().removeCallbacks(delayExecutorRunnable);
        }
        HashMap<Runnable, Runnable> hashMap2 = sExecutorRunnableCache;
        synchronized (hashMap2) {
            executorRunnable = sExecutorRunnableCache.remove(task);
        }
        YYTaskExecutor.removeRunnableFromMainThread(task);
        if (executorRunnable != null) {
            try {
                if (sThreadPool != null) {
                    sThreadPool.remove(executorRunnable);
                }
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)(" error ignore: " + e.getMessage()));
            }
        }
    }

    public static IQueueTaskExecutor createAQueueExcuter() {
        return new QueueRunnableExcuter();
    }

    public static void postToMainThread(Runnable task) {
        YYTaskExecutor.postToMainThread(task, 0L);
    }

    public static void postToMainThread(Runnable task, long delayMillis) {
        if (task == null) {
            return;
        }
        YYTaskExecutor.getMainThreadHandler().postDelayed(task, delayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postIdleRunnableToMainThread(Runnable runnable) {
        CustomIdelHandler idelHandler = new CustomIdelHandler(runnable);
        HashMap<Runnable, CustomIdelHandler> hashMap = sMainThreadIdelRunnableCache;
        synchronized (hashMap) {
            sMainThreadIdelRunnableCache.put(runnable, idelHandler);
        }
        idelHandler.post();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRunnableFromMainThread(Runnable task) {
        if (task == null) {
            return;
        }
        YYTaskExecutor.getMainThreadHandler().removeCallbacks(task);
        CustomIdelHandler idelHandler = null;
        HashMap<Runnable, CustomIdelHandler> hashMap = sMainThreadIdelRunnableCache;
        synchronized (hashMap) {
            idelHandler = sMainThreadIdelRunnableCache.remove(task);
        }
        if (idelHandler != null) {
            idelHandler.stop();
        }
    }

    public static boolean isMainThread() {
        Looper looper;
        Thread current = Thread.currentThread();
        if (sMainThread == null && (looper = Looper.getMainLooper()) != null) {
            sMainThread = looper.getThread();
        }
        return sMainThread == current;
    }

    public static synchronized void destroy() {
        if (sThreadPool != null) {
            try {
                sThreadPool.shutdown();
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Empty Catch on destroy", (Throwable)t);
            }
            sThreadPool = null;
        }
        if (sIOThreadPool != null) {
            try {
                sIOThreadPool.shutdown();
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"sIOThreadPool Empty Catch on destroy", (Throwable)t);
            }
            sIOThreadPool = null;
        }
        if (sGiftThreadPool != null) {
            try {
                sGiftThreadPool.shutdown();
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"sIOThreadPool Empty Catch on destroy", (Throwable)t);
            }
            sGiftThreadPool = null;
        }
    }

    private static HandlEx getMainThreadHandler() {
        if (sMainThreadHandler == null) {
            sMainThreadHandler = new HandlEx("MainThreadHandler + 8", Looper.getMainLooper());
        }
        return sMainThreadHandler;
    }

    private static String getStackTraceString(Throwable tr) {
        return Log.getStackTraceString((Throwable)tr);
    }

    static {
        sDelayExecutorRunnableCache = new HashMap();
        sExecutorRunnableCache = new HashMap();
        sMainThreadIdelRunnableCache = new HashMap();
        sMainThread = null;
    }

    private static class CustomIdelHandler
    implements MessageQueue.IdleHandler {
        private static final MessageQueue mMainThreadQueue = (MessageQueue)ReflectionHelper.getFieldValue(Looper.getMainLooper(), "mQueue");
        private static final Handler mHandler = new HandlEx("IdleHandler", Looper.getMainLooper());
        private static final long mRunnableDelayTime = 10000L;
        private Runnable mRunnable;
        private final Runnable mPostRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (mMainThreadQueue != null) {
                    mMainThreadQueue.removeIdleHandler((MessageQueue.IdleHandler)CustomIdelHandler.this);
                }
                CustomIdelHandler.this.mRunnable.run();
                HashMap hashMap = sMainThreadIdelRunnableCache;
                synchronized (hashMap) {
                    sMainThreadIdelRunnableCache.remove(CustomIdelHandler.this.mRunnable);
                }
            }
        };

        public CustomIdelHandler(Runnable runnable) {
            this.mRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean queueIdle() {
            mHandler.removeCallbacks(this.mPostRunnable);
            this.mRunnable.run();
            HashMap hashMap = sMainThreadIdelRunnableCache;
            synchronized (hashMap) {
                sMainThreadIdelRunnableCache.remove(this.mRunnable);
            }
            return false;
        }

        public void post() {
            if (mMainThreadQueue == null) {
                throw new Error("CustomIdelHandler main thread queue is null!");
            }
            mHandler.postDelayed(this.mPostRunnable, 10000L);
            mMainThreadQueue.addIdleHandler((MessageQueue.IdleHandler)this);
        }

        public void stop() {
            if (mMainThreadQueue != null) {
                mMainThreadQueue.removeIdleHandler((MessageQueue.IdleHandler)this);
                mHandler.removeCallbacks(this.mPostRunnable);
            }
        }
    }

    private static abstract class QueueExecutorRunnable
    extends ExecutorRunnable {
        long delayMills;

        private QueueExecutorRunnable() {
        }
    }

    private static abstract class ExecutorRunnable
    implements Runnable,
    Prioritized,
    Comparable<Prioritized> {
        Runnable task;
        Runnable callBack;
        int priority;
        int taskType;
        private ExecutorRunnable mNext;
        private static int sPoolSize = 0;
        private static final int MAX_POOL_SIZE = 100;
        private static final Object sPoolSync = new Object();
        private static ExecutorRunnable sPool;

        private ExecutorRunnable() {
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        public int hashCode() {
            return this.priority;
        }

        @Override
        public int compareTo(Prioritized loadTask) {
            return loadTask.getPriority() - this.priority;
        }

        private void reset() {
            this.task = null;
            this.callBack = null;
            this.priority = 10;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ExecutorRunnable obtain() {
            Object object = sPoolSync;
            synchronized (object) {
                if (sPool != null) {
                    ExecutorRunnable m = sPool;
                    sPool = m.mNext;
                    m.mNext = null;
                    --sPoolSize;
                    return m;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recycle() {
            this.reset();
            Object object = sPoolSync;
            synchronized (object) {
                if (sPoolSize < 100) {
                    this.mNext = sPool;
                    sPool = this;
                    ++sPoolSize;
                }
            }
        }
    }

    private static class QueueRunnableExcuter
    implements IQueueTaskExecutor {
        private ArrayList<Runnable> mTasks = new ArrayList();
        private ArrayMap<Runnable, QueueExecutorRunnable> mQueueExecutorRunnables = new ArrayMap();
        private boolean mRunning = false;

        private QueueRunnableExcuter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeNext() {
            QueueExecutorRunnable runnableToRun = null;
            QueueRunnableExcuter queueRunnableExcuter = this;
            synchronized (queueRunnableExcuter) {
                if (this.mRunning) {
                    return;
                }
                if (!this.mRunning && this.mTasks.size() > 0) {
                    runnableToRun = (QueueExecutorRunnable)this.mQueueExecutorRunnables.get((Object)this.mTasks.get(0));
                    this.mRunning = true;
                }
            }
            if (runnableToRun != null) {
                YYTaskExecutor.execute(runnableToRun, null, runnableToRun.delayMills, runnableToRun.priority);
            }
        }

        @Override
        public void execute(Runnable task, long delayMillis) {
            this.execute(task, delayMillis, 10);
        }

        @Override
        public void execute(Runnable task, long delayMillis, int priority) {
            this.execute(task, null, delayMillis, priority);
        }

        @Override
        public void execute(Runnable task, Runnable callback, long delayMillis) {
            this.execute(task, callback, delayMillis, 10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable task, Runnable callBack, long delayMills, int priority) {
            if (task == null) {
                return;
            }
            QueueExecutorRunnable executorRunnable = new QueueExecutorRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    QueueRunnableExcuter queueRunnableExcuter = QueueRunnableExcuter.this;
                    synchronized (queueRunnableExcuter) {
                        QueueRunnableExcuter.this.mTasks.remove(this.task);
                        QueueRunnableExcuter.this.mQueueExecutorRunnables.remove((Object)this.task);
                    }
                    this.task.run();
                    queueRunnableExcuter = QueueRunnableExcuter.this;
                    synchronized (queueRunnableExcuter) {
                        QueueRunnableExcuter.this.mRunning = false;
                    }
                    if (this.callBack != null) {
                        YYTaskExecutor.getMainThreadHandler().post(this.callBack);
                    }
                    QueueRunnableExcuter.this.executeNext();
                }
            };
            executorRunnable.task = task;
            executorRunnable.callBack = callBack;
            executorRunnable.delayMills = delayMills;
            executorRunnable.priority = priority;
            QueueRunnableExcuter queueRunnableExcuter = this;
            synchronized (queueRunnableExcuter) {
                this.mTasks.remove(task);
                this.mTasks.add(task);
                this.mQueueExecutorRunnables.put((Object)task, (Object)executorRunnable);
            }
            this.executeNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTask(Runnable task) {
            if (task == null) {
                return;
            }
            ExecutorRunnable executorRunnable = null;
            QueueRunnableExcuter queueRunnableExcuter = this;
            synchronized (queueRunnableExcuter) {
                this.mTasks.remove(task);
                executorRunnable = (ExecutorRunnable)this.mQueueExecutorRunnables.remove((Object)task);
            }
            if (executorRunnable != null) {
                YYTaskExecutor.removeTask(executorRunnable);
            }
        }
    }

    public static abstract class RunnableEx
    implements Runnable {
        private Object mArg;

        public void setArg(Object arg) {
            this.mArg = arg;
        }

        public Object getArg() {
            return this.mArg;
        }
    }

    public static enum TaskType {
        NORMAL,
        IO,
        GIFT;

    }
}

