/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.widget.TextView;
import com.yy.mobile.util.ResolutionUtils;

public class NoBrTextView
extends TextView {
    private final String namespace = "http://com.yy.mobile.ui.widget.NoBrTextView";
    private String text = "";
    private float textSize;
    private float paddingLeft;
    private float paddingRight;
    private float paddingTop;
    private float paddingBottom;
    private float marginLeft;
    private float marginRight;
    private int textColor;
    private int colorStart = 0;
    private int colorEnd = 0;
    private int spanColor = 0;
    private Paint paint1 = new Paint();
    private float textShowWidth;

    public NoBrTextView(Context context) {
        this(context, null);
    }

    public NoBrTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.text = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "text");
        String textSizeAttrs = attrs.getAttributeValue("http://com.yy.mobile.ui.widget.NoBrTextView", "textSize");
        String ts = textSizeAttrs.substring(0, textSizeAttrs.length() - 2);
        this.textSize = ResolutionUtils.convertDpToPixel(Float.parseFloat(ts), context);
        this.textColor = attrs.getAttributeIntValue("http://com.yy.mobile.ui.widget.NoBrTextView", "textColor", -16777216);
        String paddingLeftAttrs = attrs.getAttributeValue("http://com.yy.mobile.ui.widget.NoBrTextView", "paddingLeft");
        String pl = paddingLeftAttrs.substring(0, paddingLeftAttrs.length() - 2);
        this.paddingLeft = ResolutionUtils.convertDpToPixel(Float.parseFloat(pl), context);
        String paddingRightAttrs = attrs.getAttributeValue("http://com.yy.mobile.ui.widget.NoBrTextView", "paddingRight");
        String pr = paddingRightAttrs.substring(0, paddingRightAttrs.length() - 2);
        this.paddingRight = ResolutionUtils.convertDpToPixel(Float.parseFloat(pr), context);
        String paddingTopAttrs = attrs.getAttributeValue("http://com.yy.mobile.ui.widget.NoBrTextView", "paddingTop");
        String pt = paddingTopAttrs.substring(0, paddingTopAttrs.length() - 2);
        this.paddingTop = ResolutionUtils.convertDpToPixel(Float.parseFloat(pt), context);
        String paddingBottomAttrs = attrs.getAttributeValue("http://com.yy.mobile.ui.widget.NoBrTextView", "paddingBottom");
        String pb = paddingBottomAttrs.substring(0, paddingBottomAttrs.length() - 2);
        this.paddingBottom = ResolutionUtils.convertDpToPixel(Float.parseFloat(pb), context);
        this.marginLeft = attrs.getAttributeIntValue("http://com.yy.mobile.ui.widget.NoBrTextView", "marginLeft", 0);
        this.marginRight = attrs.getAttributeIntValue("http://com.yy.mobile.ui.widget.NoBrTextView", "marginRight", 0);
        this.paint1.setTextSize(this.textSize);
        this.paint1.setColor(this.textColor);
        this.paint1.setAntiAlias(true);
        DisplayMetrics dm = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(dm);
        this.textShowWidth = (float)dm.widthPixels - this.paddingLeft - this.paddingRight - this.marginLeft - this.marginRight;
    }

    public void setTextSpanColor(int colorStart, int colorEnd, int color2) {
        this.colorStart = colorStart;
        this.colorEnd = colorEnd;
        this.spanColor = color2;
    }

    protected void onDraw(Canvas canvas) {
        int lineCount = 0;
        if (this.getText() == null) {
            return;
        }
        this.text = this.getText().toString();
        char[] textCharArray = this.text.toCharArray();
        float drawedWidth = 0.0f;
        for (int i = 0; i < textCharArray.length; ++i) {
            float charWidth = this.paint1.measureText(textCharArray, i, 1);
            if (textCharArray[i] == '\n') {
                ++lineCount;
                drawedWidth = 0.0f;
                continue;
            }
            if (this.textShowWidth - drawedWidth < charWidth) {
                ++lineCount;
                drawedWidth = 0.0f;
            }
            if (this.colorEnd > 0) {
                if (i >= this.colorStart && i <= this.colorEnd) {
                    this.paint1.setColor(this.spanColor);
                } else {
                    this.paint1.setColor(this.textColor);
                }
            } else {
                this.paint1.setColor(this.textColor);
            }
            canvas.drawText(textCharArray, i, 1, this.paddingLeft + drawedWidth, this.paddingTop + (float)(lineCount + 1) * this.textSize, this.paint1);
            drawedWidth += charWidth;
        }
        this.setHeight((lineCount + 1) * (int)this.textSize + 5 + (int)this.paddingTop + (int)this.paddingBottom);
    }
}

