/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.crash;

import android.content.Context;
import android.text.TextUtils;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.util.pref.YSharedPref;
import java.util.ArrayList;
import java.util.List;

class CrashPref
extends YSharedPref {
    private static final String CRASH_FREQUENCY_CHECK = "crash_frequence_check_pref";
    private static final String CRASH_CONFIG = "crash_config";
    private static final String CRASH_TIMESTAMPS = "crash_time_info";
    private static final String SHOW_SAFE_MODE = "show_safe_mode";

    private CrashPref() {
        super(SharedPreferencesUtils.getSharedPreferences((Context)BasicConfig.getInstance().getAppContext(), (String)CRASH_FREQUENCY_CHECK, (int)0));
    }

    public static synchronized CrashPref instance() {
        return Holder.sInstance;
    }

    public boolean getShouldShowSafeMode() {
        return this.getBoolean(SHOW_SAFE_MODE, false);
    }

    public void setShouldShowSafeMode(boolean b) {
        this.putBoolean(SHOW_SAFE_MODE, b);
    }

    public int[] getCrashConfig() {
        String s = this.getString(CRASH_CONFIG, "");
        int[] rv = null;
        if (!TextUtils.isEmpty((CharSequence)s)) {
            String[] sv = s.split(":");
            rv = new int[sv.length];
            int size = sv.length;
            for (int i = 0; i < size; ++i) {
                rv[i] = Integer.valueOf(sv[i]);
            }
        }
        return rv;
    }

    public void putCrashConfig(int duration, int frequet) {
        this.putString(CRASH_CONFIG, String.format("%s:%s", duration, frequet));
    }

    public void putCrashTimeStamps(List<Long> list) {
        StringBuilder builder = new StringBuilder();
        for (Long l : list) {
            if (builder.length() != 0) {
                builder.append(",");
            }
            builder.append(l);
        }
        this.putString(CRASH_TIMESTAMPS, builder.toString());
    }

    public List<Long> getCrashTimeStamps() {
        String s = this.getString(CRASH_TIMESTAMPS, "");
        ArrayList<Long> rv = null;
        if (!TextUtils.isEmpty((CharSequence)s)) {
            String[] sv = s.split(",");
            rv = new ArrayList(sv.length);
            for (String i : sv) {
                rv.add(Long.valueOf(i));
            }
        }
        return rv == null ? new ArrayList<Long>() : rv;
    }

    static class Holder {
        static CrashPref sInstance = new CrashPref();

        Holder() {
        }
    }
}

