/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.crash;

import android.content.Context;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.crash.CrashHandler;
import com.yy.mobile.crash.CrashSDKLogAdapter;
import com.yy.mobile.uniondif.AppIdConfig;
import com.yy.mobile.util.AppMetaDataUtil;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.log.LogCurrentWritingPath;
import com.yy.mobile.util.log.LogManager;
import com.yy.mobile.util.log.MLog;
import com.yy.sdk.crashreport.CrashReport;
import com.yy.sdk.crashreport.ILog;
import java.io.File;
import java.util.Calendar;
import java.util.Map;

public class CrashSdkHelper {
    public static final String TAG = "CrashSdkHelper";
    private static CrashSdkHelper sInst;

    public static synchronized CrashSdkHelper instance() {
        if (sInst == null) {
            sInst = new CrashSdkHelper();
        }
        return sInst;
    }

    private CrashSdkHelper() {
    }

    public void initCrashSDK(Context context, Map<String, String> extInfoMap) {
        try {
            new CrashHandler(Thread.getDefaultUncaughtExceptionHandler(), context.getFilesDir());
            CrashReport.init((CrashReport.CrashReportBuilder)new CrashReport.CrashReportBuilder().setContext(context).setAppId(AppIdConfig.getAppIds().getCrashSdkAppId()).setAppMarket(AppMetaDataUtil.getChannelID((Context)context)).setLogger((ILog)new CrashSDKLogAdapter()).setGUid(CommonUtils.getImei((Context)context)));
            CrashReport.startANRDetecting((Context)context);
            if (extInfoMap != null) {
                CrashReport.setExtInfo(extInfoMap);
            }
            this.setCurrentLogFilePath();
        }
        catch (Throwable ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
    }

    private static String createLogFileName() {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        int minute = c.get(12);
        StringBuffer buffer = new StringBuffer(MLog.getOptions().logIdentifier + "_" + year);
        if (month > 9) {
            buffer.append("_");
            buffer.append(month);
        } else {
            buffer.append("_0");
            buffer.append(month);
        }
        if (day > 9) {
            buffer.append("_");
            buffer.append(day);
        } else {
            buffer.append("_0");
            buffer.append(day);
        }
        if (hour > 9) {
            buffer.append("_");
            buffer.append(hour);
        } else {
            buffer.append("_0");
            buffer.append(hour);
        }
        if (minute > 9) {
            buffer.append("_");
            buffer.append(minute);
        } else {
            buffer.append("_0");
            buffer.append(minute);
        }
        buffer.append(".txt");
        return buffer.toString();
    }

    public void setCurrentLogFilePath() {
        try {
            LogManager.getInstance().setPathListener(new LogCurrentWritingPath(){

                public void updateCurrentLogPath(String path) {
                    MLog.info((Object)CrashSdkHelper.TAG, (String)("log path:" + path), (Object[])new Object[0]);
                    String logRootDir = BasicConfig.getInstance().getLogDirPath();
                    String mediaSdkLog = BasicConfig.getInstance().getSDKLogDirPath() + File.separator + "mediaSdk-trans.txt";
                    CrashReport.setUserLogList((String[])new String[]{path, logRootDir + File.separator + "uncaught_exception.txt", mediaSdkLog});
                }
            });
        }
        catch (Throwable ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
    }
}

