/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.crash;

import android.content.Context;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.MEIPAI;
import com.unionyy.mobile.spdt.annotation.SpdtActual;
import com.unionyy.mobile.spdt.annotation.SpdtExpect;
import com.unionyy.mobile.spdt.annotation.XIAOMI;
import com.yy.mobile.crash.CrashFrequencyChecker;
import com.yy.mobile.crash.CrashSdkHelper;
import com.yy.mobile.crash.UncatchCrashReporter;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.sdk.crashreport.CrashReport;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;

public class CrashSdk {
    public static final String TAG = "CrashSdk";

    public static void initCrashSDK(Context context) {
        CrashReport.setAppVersion((String)((CrashUploadVersion)Spdt.of(CrashUploadVersion.class)).getVersion(context));
        HashMap<String, String> sExtInfo = new HashMap<String, String>();
        CrashSdkHelper.instance().initCrashSDK(context, sExtInfo);
        CrashReport.setCrashCallback((CrashReport.CrashCallback)new CrashReport.CrashCallback(){

            public void preCrashCallback(boolean isNativeCrash, String dumpFile, String dumpSymbolFile, String logFile) {
            }

            public void crashCallback(String crashId, boolean isNativeCrash, String dumpFile, String dumpSymbolFile, String logFile) {
                MLog.error((Object)CrashSdk.TAG, (String)("crashCallback crashId:" + crashId + " isNativeCrash:" + isNativeCrash + " dumpFile:" + dumpFile), (Object[])new Object[0]);
                if (isNativeCrash) {
                    UncatchCrashReporter.handleMessage((int)3, null);
                    CrashSdk.writeNativeCrashToLog(crashId, dumpFile);
                } else {
                    UncatchCrashReporter.handleMessage((int)2, null);
                }
                CrashFrequencyChecker.instance().addCrashCountRecord();
            }

            public void afterCrashCallback(String crashId, boolean isNativeCrash, String dumpFile, String dumpSymbolFile, String logFile) {
            }
        });
    }

    private static void writeNativeCrashToLog(String crashId, String dumpFile) {
        String time = "";
        try {
            Calendar logCal = Calendar.getInstance();
            logCal.setTimeInMillis(System.currentTimeMillis());
            time = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd kk:mm:ss.SSS").format(logCal.getTime());
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (String)"writeNativeCrashToLog", (Object[])new Object[0]);
        }
        if (time == null) {
            time = "";
        }
        try {
            String fakeLogTrace = " Exception occurs at java.lang.Throwable: NativeCrashException : \ncrashId:" + crashId + "\ndumpFile:" + dumpFile;
            File unCatchFile = new File(MLog.getLogPath(), "uncaught_exception.txt");
            if (unCatchFile.exists() && unCatchFile.length() > 0x200000L) {
                try {
                    unCatchFile.delete();
                    unCatchFile = new File(MLog.getLogPath(), "uncaught_exception.txt");
                }
                catch (Exception e) {
                    MLog.error((Object)"CrashHandler", (String)(" delete" + e.toString()), (Object[])new Object[0]);
                }
            }
            FileUtil.writeBytesToFile((File)unCatchFile, (byte[])("\n\n" + time + " " + fakeLogTrace).getBytes(), (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    @SpdtActual(value=MEIPAI.class)
    public static class MeiPaiMiVersion
    implements CrashUploadVersion {
        @Override
        public String getVersion(Context context) {
            return VersionUtil.getLocalName((Context)context) + "-" + "5.0.1-SNAPSHOT";
        }
    }

    @SpdtActual(value=XIAOMI.class)
    public static class XiaoMiVersion
    implements CrashUploadVersion {
        @Override
        public String getVersion(Context context) {
            return "1.0.16-3443-APK ";
        }
    }

    @SpdtActual
    public static class DefaultVersion
    implements CrashUploadVersion {
        @Override
        public String getVersion(Context context) {
            return VersionUtil.getLocalName((Context)context) + "-" + "5.0.1-SNAPSHOT";
        }
    }

    @SpdtExpect
    public static interface CrashUploadVersion {
        public String getVersion(Context var1);
    }
}

