/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.crash;

import com.yy.mobile.crash.CrashPref;
import java.util.ArrayList;
import java.util.List;

class CrashFrequencyChecker {
    CrashFrequencyChecker() {
    }

    public static CrashFrequencyChecker instance() {
        return Holder.mInstance;
    }

    public void addCrashCountRecord() {
        int[] config = this.getCrashConfig();
        List<Long> list = CrashPref.instance().getCrashTimeStamps();
        long current = System.currentTimeMillis();
        ArrayList<Long> removeList = new ArrayList<Long>();
        for (Long l : list) {
            if (current - l <= (long)(config[0] * 1000)) continue;
            removeList.add(l);
        }
        list.removeAll(removeList);
        list.add(current);
        CrashPref.instance().putCrashTimeStamps(list);
        CrashPref.instance().setShouldShowSafeMode(list.size() >= config[1]);
    }

    public void decreaseCrashCount() {
        List<Long> list = CrashPref.instance().getCrashTimeStamps();
        list.remove(0);
        CrashPref.instance().putCrashTimeStamps(list);
        int[] config = this.getCrashConfig();
        CrashPref.instance().setShouldShowSafeMode(list.size() >= config[1]);
    }

    public boolean crashFrequencyCheck() {
        return CrashPref.instance().getShouldShowSafeMode();
    }

    public void resetLocalCrashRecord() {
        CrashPref.instance().clear();
    }

    private int[] getCrashConfig() {
        int[] config = new int[]{300, 3};
        return config;
    }

    private static class Holder {
        static CrashFrequencyChecker mInstance = new CrashFrequencyChecker();

        private Holder() {
        }
    }
}

