/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.crash;

import android.app.Activity;
import android.app.FragmentManager;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.crash.UncatchCrashReporter;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = "CrashHandler";
    private Thread.UncaughtExceptionHandler sDefaultHandler;
    private File soPath;

    public CrashHandler(Thread.UncaughtExceptionHandler sDefaultHandler, File soPath) {
        this.sDefaultHandler = sDefaultHandler;
        this.soPath = soPath;
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        try {
            UncatchCrashReporter.handleMessage((int)2, (Object)ex);
            String crashData = this.collectStackTrace(ex);
            this.writeTraceToLog(crashData, ex);
            this.writeActivityId();
            MLog.flush();
            if (BasicConfig.getInstance().isDebuggable()) {
                Thread.sleep(2000L);
            } else {
                Thread.sleep(1500L);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
        if (ex instanceof UnsatisfiedLinkError) {
            this.onUnsatisfiedLinkError();
        } else if (this.sDefaultHandler != null) {
            this.sDefaultHandler.uncaughtException(thread, ex);
        }
    }

    private void onUnsatisfiedLinkError() {
        MLog.info((Object)TAG, (String)("onUnsatisfiedLinkError, soPath:" + this.soPath.getAbsolutePath()), (Object[])new Object[0]);
        if (this.soPath != null && this.soPath.exists() && this.soPath.isDirectory()) {
            for (File soFile : this.soPath.listFiles()) {
                MLog.info((Object)TAG, (String)("find so:" + soFile.getName()), (Object[])new Object[0]);
            }
        }
    }

    private void writeActivityId() {
        MLog.info((Object)TAG, (String)"writeActivityId() called.", (Object[])new Object[0]);
        String activityFilePath = MLog.getLogPath() + File.separator + "log_activity.txt";
        List<String> list = this.getActivityFramentIDList();
        StringBuffer buffer = new StringBuffer("");
        for (String ac : list) {
            if (ac == null) continue;
            buffer.append(ac);
            buffer.append("\r\n");
        }
        try {
            FileUtil.writeBytesToFile((File)FileUtil.createNewFile((String)activityFilePath), (byte[])buffer.toString().getBytes(), (boolean)false, (boolean)true);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    private List<String> getActivityFramentIDList() {
        ArrayList<String> list = new ArrayList<String>();
        Class<?> activityThreadClass = null;
        try {
            activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
            activitiesField.setAccessible(true);
            Map activities = (Map)activitiesField.get(activityThread);
            for (Object activityRecord : activities.values()) {
                FragmentActivity framentActivity;
                List framentList;
                Class<?> activityRecordClass = activityRecord.getClass();
                Field activityField = activityRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                Activity activity = (Activity)activityField.get(activityRecord);
                if (activity == null) continue;
                list.add(activity.toString());
                int num = activity.getFragmentManager().getBackStackEntryCount();
                for (int i = 0; i < num; ++i) {
                    FragmentManager.BackStackEntry backstatck;
                    FragmentManager fm = activity.getFragmentManager();
                    if (fm == null || (backstatck = fm.getBackStackEntryAt(i)) == null) continue;
                    list.add(backstatck.getName() + "@" + backstatck.getId());
                }
                if (!(activity instanceof FragmentActivity) || (framentList = (framentActivity = (FragmentActivity)activity).getSupportFragmentManager().getFragments()) == null) continue;
                for (Fragment fragment : framentList) {
                    if (fragment == null) continue;
                    list.add(fragment.toString());
                }
            }
        }
        catch (ClassNotFoundException e) {
            MLog.error((Object)TAG, (String)"ClassNotFoundException: ", (Throwable)e, (Object[])new Object[0]);
        }
        catch (NoSuchMethodException e) {
            MLog.error((Object)TAG, (String)"NoSuchMethodException: ", (Throwable)e, (Object[])new Object[0]);
        }
        catch (IllegalAccessException e) {
            MLog.error((Object)TAG, (String)"IllegalAccessException: ", (Throwable)e, (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            MLog.error((Object)TAG, (String)"InvocationTargetException: ", (Throwable)e, (Object[])new Object[0]);
        }
        catch (NoSuchFieldException e) {
            MLog.error((Object)TAG, (String)"NoSuchFieldException: ", (Throwable)e, (Object[])new Object[0]);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"Exception: ", (Throwable)e, (Object[])new Object[0]);
        }
        return list;
    }

    public String collectStackTrace(Throwable th) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        Throwable cause = th;
        if (cause != null) {
            cause.printStackTrace(printWriter);
        }
        String stackTrace = ((Object)result).toString();
        printWriter.close();
        return stackTrace.trim();
    }

    private void writeTraceToLog(String traces, Throwable ex) {
        String time = "";
        try {
            Calendar logCal = Calendar.getInstance();
            logCal.setTimeInMillis(System.currentTimeMillis());
            time = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd kk:mm:ss.SSS").format(logCal.getTime());
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (String)traces, (Object[])new Object[0]);
        }
        if (time == null) {
            time = "";
        }
        try {
            MLog.error((Object)TAG, (String)traces, (Object[])new Object[0]);
            File unCatchFile = new File(MLog.getLogPath(), "uncaught_exception.txt");
            if (unCatchFile.exists() && unCatchFile.length() > 0x200000L) {
                try {
                    unCatchFile.delete();
                    unCatchFile = new File(MLog.getLogPath(), "uncaught_exception.txt");
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)(" delete" + e.toString()), (Object[])new Object[0]);
                }
            }
            FileUtil.writeBytesToFile((File)unCatchFile, (byte[])("\n\n" + time + " " + traces).getBytes(), (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }
}

