package com.yy.mobile.replugin;

import android.util.Log;

import com.yy.mobile.ipc.IPCManager;
import com.yy.mobile.ipc.IpcApiSetting;

import com.unionyy.ipcapi.Hermes;
import com.unionyy.ipcapi.util.TypeUtils;

/**
 * Create by guananjie on 2020-02-26
 * E-mail: guananjie@yy.com
 * YY: 909042007
 */
public class ApiIpcBridge {
    public static <T> T registerIpc(Class<T> clazz) {
        try {
            if (IPCManager.instance != null) {
                IpcApiSetting setting = IPCManager.instance.getIpcApiSetting();
                if (setting == IpcApiSetting.Server && TypeUtils.getClassId(clazz) != null) {
                    T t = ImplUtil.getImpl(clazz);
                    Hermes.register(t.getClass());
                    Log.i("RepluginBridge", "register,ipc clazz:" + t.getClass());

                }
            }
        } catch (Exception e) {
            Log.e("RepluginBridge", "registerIpc", e);
        }
        return null;
    }

    public static <T> T getApi(Class<T> clazz) {
        if (IPCManager.instance != null) {
            try {
                IpcApiSetting setting = IPCManager.instance.getIpcApiSetting();
                    if (setting == IpcApiSetting.Clinet && TypeUtils.getClassId(clazz) != null && IPCManager.connectStatus) {
                        T temp = Hermes.newInstance(clazz);
                        if (temp != null) {
                            Log.i("RepluginBridge", "getIPCApi,clazz:" + clazz + " of instance is" + temp);
                            return temp;
                        }
                    }

            } catch (Exception e) {
                Log.e("RepluginBridge", "getApi", e);
            }
        }
        return null;
    }
}
