/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ipc;

import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\t\b&\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0086\u0002J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u0007J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0017J\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0007J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u001cJ\u001a\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00072\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fJ\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J\u0018\u0010 \u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0015H\u0002J\u0016\u0010#\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007J\u0016\u0010$\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u000fJ\u0016\u0010%\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0015J#\u0010&\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150(\u00a2\u0006\u0002\u0010)J \u0010*\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0010\u0010'\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u001aJ\u0016\u0010+\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u001cJ\u0016\u0010,\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0001J\u0016\u0010.\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007J\u000e\u0010/\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007R\u001b\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00061"}, d2={"Lcom/yy/mobile/ipc/AbstractSharedPref;", "", "mPref", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "all", "", "", "getAll", "()Ljava/util/Map;", "getMPref", "()Landroid/content/SharedPreferences;", "clear", "", "contain", "", "key", "get", "getBoolean", "defaultValue", "getInt", "", "getIntArray", "", "outValues", "getIntList", "", "getLong", "", "getObj", "className", "Ljava/lang/Class;", "getString", "parseInt", "value", "put", "putBoolean", "putInt", "putIntArray", "values", "", "(Ljava/lang/String;[Ljava/lang/Integer;)V", "putIntList", "putLong", "putObject", "obj", "putString", "remove", "Companion", "commonsdk_release"})
public abstract class AbstractSharedPref {
    @NotNull
    private final SharedPreferences mPref;
    public static final Companion Companion = new Companion(null);

    public final void putString(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.put(key, value);
    }

    @NotNull
    public final String getString(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = this.get(key);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getString(@NotNull String key, @Nullable String defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = this.mPref.getString(key, defaultValue);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final void putInt(@NotNull String key, int value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.put(key, String.valueOf(value));
    }

    public final void putBoolean(@NotNull String key, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.put(key, String.valueOf(value));
    }

    public final boolean getBoolean(@NotNull String key, boolean defaultValue) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String rawValue = this.get(key);
        if (TextUtils.isEmpty((CharSequence)rawValue)) {
            bl = defaultValue;
        } else {
            boolean bl2;
            try {
                bl2 = Boolean.parseBoolean(rawValue);
            }
            catch (Exception e) {
                Log.e((String)"YSharedPref", (String)("failed to parse boolean value for key " + key), (Throwable)e);
                bl2 = defaultValue;
            }
            bl = bl2;
        }
        return bl;
    }

    public final int getInt(@NotNull String key, int defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = this.get(key);
        if (string == null) {
            string = "";
        }
        String rawValue = string;
        return TextUtils.isEmpty((CharSequence)rawValue) ? defaultValue : this.parseInt(rawValue, defaultValue);
    }

    private final int parseInt(String value, int defaultValue) {
        int n;
        try {
            String string = value;
            boolean bl = false;
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            Log.e((String)"YSharedPref", (String)("lcy failed to parse value for key " + value), (Throwable)e);
            n = defaultValue;
        }
        return n;
    }

    public final int getInt(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.getInt(key, -1);
    }

    public final void putLong(@NotNull String key, long value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.put(key, String.valueOf(value));
    }

    public final long getLong(@NotNull String key, long defaultValue) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String rawValue = this.get(key);
        if (TextUtils.isEmpty((CharSequence)rawValue)) {
            l = defaultValue;
        } else {
            long l2;
            try {
                long l3;
                String string = rawValue;
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    l3 = Long.parseLong(string2);
                } else {
                    l3 = 0L;
                }
                l2 = l3;
            }
            catch (NumberFormatException e) {
                Log.e((String)"YSharedPref", (String)("lcy failed to parse " + rawValue + " as long, for key " + key + ", ex : %s"), (Throwable)e);
                l2 = defaultValue;
            }
            l = l2;
        }
        return l;
    }

    public final long getLong(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.getLong(key, -1L);
    }

    public final void putIntArray(@NotNull String key, @NotNull Integer[] values) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        this.putIntList(key, CollectionsKt.listOf((Object[])Arrays.copyOf(values, values.length)));
    }

    @Nullable
    public final int[] getIntArray(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.getIntArray(key, new int[0]);
    }

    @Nullable
    public final int[] getIntArray(@NotNull String key, @NotNull int[] outValues) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)outValues, (String)"outValues");
        List<Integer> list = this.getIntList(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        int[] ret = list.size() <= outValues.length ? outValues : new int[list.size()];
        int i = 0;
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            int e = ((Number)iterator.next()).intValue();
            ret[i++] = e;
        }
        return ret;
    }

    public final void putIntList(@NotNull String key, @Nullable List<Integer> values) {
        String value;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (values == null || values.size() == 0) {
            return;
        }
        String string = value = TextUtils.join((CharSequence)",", (Iterable)values);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
        this.put(key, string);
    }

    @Nullable
    public final List<Integer> getIntList(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String val = this.get(key);
        if (TextUtils.isEmpty((CharSequence)val)) {
            return null;
        }
        String[] values = TextUtils.split((String)val, (String)",");
        if (values == null || values.length == 0) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String e : values) {
            try {
                String string;
                Intrinsics.checkExpressionValueIsNotNull((Object)e, (String)"e");
                ArrayList<Integer> arrayList = list;
                boolean bl = false;
                int n = Integer.parseInt(string);
                arrayList.add(n);
            }
            catch (NumberFormatException ex) {
                Log.e((String)"YSharedPref", (String)("lcy failed to parse value for key: " + key + ", value: " + e + ", exception: %s"), (Throwable)ex);
            }
        }
        return list;
    }

    public final void put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.mPref.edit().putString(key, value).apply();
    }

    @Nullable
    public final String get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.mPref.getString(key, null);
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.mPref.edit().remove(key).apply();
    }

    public final void clear() {
        this.mPref.edit().clear().apply();
    }

    @NotNull
    public final Map<String, ?> getAll() {
        Map map = this.mPref.getAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"mPref.all");
        return map;
    }

    public final boolean contain(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        CharSequence charSequence = key;
        boolean bl = false;
        return charSequence.length() == 0 ? false : this.mPref.contains(key);
    }

    public final void putObject(@NotNull String key, @NotNull Object obj) {
        String json;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Gson gson = new Gson();
        String string = json = gson.toJson(obj);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json");
        this.put(key, string);
    }

    @NotNull
    public final Object getObj(@NotNull String key, @NotNull Class<?> className) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(className, (String)"className");
        Gson gson = new Gson();
        String json = this.getString(key, "");
        Object object = gson.fromJson(json, className);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(json, className)");
        return object;
    }

    @NotNull
    protected final SharedPreferences getMPref() {
        return this.mPref;
    }

    public AbstractSharedPref(@NotNull SharedPreferences mPref) {
        Intrinsics.checkParameterIsNotNull((Object)mPref, (String)"mPref");
        this.mPref = mPref;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/yy/mobile/ipc/AbstractSharedPref$Companion;", "", "()V", "DELIMITER", "", "TAG", "commonsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

