package com.yy.mobile.baseapi

import com.yy.mobile.miapi.AuthCallback
import org.jetbrains.annotations.TestOnly

/**
 * Created by 张宇 on 2019/3/6.
 * E-mail: zhangyu4@yy.com
 * YY: 909017428
 */
interface Union2YYAuthAction {

    /**
     * 登出当前 YY账号
     */
    fun logout()

    /**
     * 是否登录着 YY账号
     */
    fun isYYLogined(): Boolean

    /**
     * 如果 [isYYLogined] 为true时，可以获得 YY账号的 uid。否则为null
     */
    fun getCurrentYYId(): Long?

    /**
     * 如果 [isYYLogined] 为true时，可以获得 YY账号的 ticket。否则为null
     */
    fun getTicket(): String?


    /**
     * 授权登陆
     * 用户没有登陆任何账号时调用。调用该接口会调起手机YY第三方登陆的界面，登陆成功后，
     * 用户是YY用户，并返回 yyUid 和 ticket。
     * 小米利用 yyUid 和 ticket 创建小米账号并登陆。
     *
     * @param callback 登陆结果回调
     */
    fun authorizedLogin(callback: AuthCallback)

    /**
     * 小米账号绑定YY账号登陆
     * 用户已经登陆小米账号时调用。用户是小米用户，具有 zbid 和 accesstoken。
     * YY 利用 zbid 和 accesstoken 创建YY账号并登陆。
     * 登陆成功后，用户既是YY用户也是小米用户，并返回 yyUid 和 ticket。
     * 小米利用 yyUid 和 ticket 对YY账号和小米账号进行绑定。
     *
     * @param zbId 小米直播用户id
     * @param accessToken 小米授权凭证，数据类型在实现时可能会调整
     * @param callback 登陆结果回调
     */
    fun bindLogin(zbId: Long, accessToken: String, callback: AuthCallback)

    /**
     * 账号密码登录
     * @param user 通行证、YY号、邮箱、手机号之一
     * @param password 未加密的密码
     */
    @TestOnly
    fun login(user: String, password: String, callback: AuthCallback)
}