package com.yy.mobile.miapi

import android.content.Context

/**
 * Created by 张宇 on 2019/4/19.
 * E-mail: zhangyu4@yy.com
 * YY: 909017428
 */
interface MI2YYSmallVideoAction {

    /**
     * 跳转小视频播放页
     *
     * @param videoInfoJson 小视频信息的Json, 相当于 toJson(SmallVideoInfo)
     * @param videoInfoListJson 上下滑小视频列表的Json, 相当于 toJson(List<SmallVideoInfo>)
     *
     * videoInfoListJson 代表的List里面可以包含当前要播放的 videoInfoJson，上下滑会对应上。
     * 如果 videoInfoListJson 中不包含 videoInfoJson，那么会把 videoInfoJson 当作是上下滑中的第一个。
     */
    fun toSmallVideoPage(context: Context, videoInfoJson: String, videoInfoListJson: String? = null)

    /*
        @Parcelize
        data class SmallVideoInfo(
            /**
             * 视频播放url
             */
            @SerializedName("resUrl")
            val resUrl: String,
            /**
             * 作者uid
             */
            @SerializedName("uid")
            val anchorUid: Long,
            /**
             * 视频标题/描述
             */
            @SerializedName("desc")
            val desc: String? = "",
            /**
             * 视频的封面
             */
            @SerializedName("thumb")
            val snapshot: String? = null,
            /**
             * "n*m", dpi = n / m
             */
            @SerializedName("dpi")
            val dpiStr: String? = null,
            @SerializedName("tag")
            val tag: String? = null
        ) : Parcelable
     */
}