package com.yy.mobile.ipc

import android.content.Context
import android.content.SharedPreferences
import android.util.Log
import com.unionyy.ipcapi.HermesListener
import com.unionyy.ipcapi.HermesService

/**
 * Create by guananjie on 2020-02-26
 * E-mail: guananjie@yy.com
 * YY: 909042007
 */
class IPCManager(pref: SharedPreferences) : AbstractSharedPref(pref) {
    companion object {
        var PREF_IPC_API_SETTING = "PREF_IPC_API_SETTING"
        var PREF_IPC_API_CONNECT_APP_SETTING = "PREF_IPC_API_CONNECT_APP_SETTING"

        @JvmField
        @Volatile
        var instance: IPCManager? = null

        @JvmStatic
        @Synchronized
        fun init(context: Context) {
            if (instance == null) {
                val pref: SharedPreferences =
                    context.getSharedPreferences("IPCSharedPref", Context.MODE_PRIVATE)
                instance = IPCManager(pref)
            }
        }
        @JvmField
        var connectStatus = false
        val iPCListener: HermesListener = object : HermesListener() {
            override fun onHermesConnected(service: Class<out HermesService>?) {
                Log.i("IPCApiBridge", "onServiceConnected success")
                connectStatus = true
            }

            override fun onHermesDisconnected(service: Class<out HermesService>?) {
                Log.i("IPCApiBridge", "onHermesDisconnected")
                connectStatus = false
            }

        }

    }


    /**
     * sav ipc api setting
     *
     * @param ipcApiSetting
     * @param connectAppName
     */
    fun setIpcApiSetting(
        ipcApiSetting: IpcApiSetting
    ) {
        putInt(PREF_IPC_API_SETTING, ipcApiSetting.ordinal)
    }

    fun setConnectAppName(
        connectAppName: String
    ) {
        putString(PREF_IPC_API_CONNECT_APP_SETTING, connectAppName)

    }


    fun getIpcApiSetting(): IpcApiSetting {
        val ordinal = getInt(PREF_IPC_API_SETTING, -1)
        if (ordinal > -1 && ordinal < IpcApiSetting.values().size) {
            return IpcApiSetting.values()[ordinal]
        }
        return IpcApiSetting.None
    }

    fun getIpcApiConnectApp(): String {
        return getString(PREF_IPC_API_CONNECT_APP_SETTING, "")
    }


}