package com.yy.mobile.dialog

import android.app.Activity
import android.app.Application
import android.content.Intent
import com.yy.mobile.init.DefaultActivityLifecycleCallbacks
import com.yy.mobile.init.UnionActivityManager
import com.yy.mobile.init.UnionServicesKeeper
import com.yy.mobile.init.UnionServicesKeeper.YY_PROCESS_NAME_END
import com.yy.mobile.util.getCurProcessName
import tv.athena.ipc.api.IPC
import tv.athena.ipc.api.IPCService

/**
 * Created by wangfeihang on 2019/3/29.
 */
object UnionContextUtil {
    fun requestUnionContext(responseCallback: UnionContextResponseCallback) {
        resumeTranslateActivity(responseCallback)
    }

    private fun resumeTranslateActivity(responseCallback: UnionContextResponseCallback) {
        var translateActivityClass = getCurTranslateActivityClass()
        UnionActivityManager.mCurActivity?.let {
            if (it::class.java == translateActivityClass) {
                responseCallback.onResponse(it)
                return
            }
        }

        val activityLifecycleCallbacks = object : DefaultActivityLifecycleCallbacks() {
            override fun onActivityResumed(activity: Activity?) {
                activity?.let {
                    if (activity::class.java == translateActivityClass) {
                        responseCallback.onResponse(activity)
                    }
                }
            }
        }
        (IPC.ipcApi.getContext() as Application).registerActivityLifecycleCallbacks(activityLifecycleCallbacks)
        getCurService()?.let {
            it.startActivity(Intent(it, translateActivityClass))
        }
    }

    fun onHideUnionUI(context: Activity?) {
        if (context == null) {
            var translateActivityClass = getCurTranslateActivityClass()
            UnionActivityManager.mCurActivity?.let {
                if (it::class.java == translateActivityClass) {
                    UnionActivityManager.mCurActivity?.safeFinish()
                    return
                }
            }
        } else {
            context.safeFinish()
        }
    }

    private fun Activity.safeFinish() {
        if (!this.isFinishing) {
            this.finish()
        }
    }

    private fun getCurTranslateActivityClass(): Class<out BaseUnionTranslateActivity> {
        val curProcessName = IPC.ipcApi.getContext().getCurProcessName()
        return when {
            curProcessName?.endsWith(YY_PROCESS_NAME_END) == true -> SmallProcessTranslateActivity::class.java
            curProcessName == IPC.ipcApi.getContext().packageName -> MainProcessTranslateActivity::class.java
            else -> throw
            Exception("The process is not main process or small process!Check your process:$curProcessName")
        }
    }

    private fun getCurService(): IPCService? {
        val curProcessName = IPC.ipcApi.getContext().getCurProcessName()
        return when {
            curProcessName?.endsWith(YY_PROCESS_NAME_END) == true -> UnionServicesKeeper.smallProcessService
            curProcessName == IPC.ipcApi.getContext().packageName -> UnionServicesKeeper.mainProcessService
            else -> throw
            Exception("The process is not main process or small process!Check your process:$curProcessName")
        }
    }

    interface UnionContextResponseCallback {
        fun onResponse(context: Activity)
    }
}