/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.replugin;

import android.util.Log;
import com.unionyy.ipcapi.Hermes;
import com.unionyy.ipcapi.util.TypeUtils;
import com.yy.mobile.ipc.IPCManager;
import com.yy.mobile.ipc.IpcApiSetting;
import com.yy.mobile.replugin.ImplFactory;
import com.yy.mobile.replugin.ImplUtil;
import java.util.concurrent.ConcurrentHashMap;

public class ApiIpcBridge {
    private static volatile boolean isFirstInit = true;

    public static <T> T registerIpc(Class<T> clazz) {
        try {
            IpcApiSetting setting;
            if (IPCManager.instance != null && (setting = IPCManager.instance.getIpcApiSetting()) == IpcApiSetting.Server) {
                if (isFirstInit) {
                    isFirstInit = false;
                    ConcurrentHashMap<Class<?>, ImplFactory<?>> map = ImplUtil.getClassMap();
                    for (Object key : map.keySet()) {
                        Class tempClass = (Class)key;
                        Log.i((String)"RepluginBridge", (String)("tempClass = " + tempClass));
                        ApiIpcBridge.realRegister(tempClass);
                    }
                } else {
                    ApiIpcBridge.realRegister(clazz);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"RepluginBridge", (String)"registerIpc", (Throwable)e);
        }
        return null;
    }

    private static <T> void realRegister(Class<T> clazz) {
        if (TypeUtils.getClassId(clazz) != null) {
            T t = ImplUtil.getImpl(clazz);
            Hermes.register(t.getClass());
            Log.i((String)"RepluginBridge", (String)("register,ipc clazz:" + t.getClass()));
        }
    }

    public static <T> T getApi(Class<T> clazz) {
        if (IPCManager.instance != null) {
            try {
                Object temp;
                IpcApiSetting setting = IPCManager.instance.getIpcApiSetting();
                if (setting == IpcApiSetting.Clinet && TypeUtils.getClassId(clazz) != null && IPCManager.connectStatus && (temp = Hermes.newInstance(clazz, (Object[])new Object[0])) != null) {
                    Log.i((String)"RepluginBridge", (String)("getIPCApi,clazz:" + clazz + " of instance is" + temp));
                    return (T)temp;
                }
            }
            catch (Exception e) {
                Log.e((String)"RepluginBridge", (String)"getApi", (Throwable)e);
            }
        }
        return null;
    }
}

