package com.yy.mobile.init

import android.app.Activity
import android.app.Application
import android.os.Bundle

/**
 * Created by wangfeihang on 2019/3/29.
 */
object UnionActivityManager {

    var mCurActivity: Activity? = null

    fun init(application: Application) {
        application.registerActivityLifecycleCallbacks(object : DefaultActivityLifecycleCallbacks() {
            override fun onActivityResumed(activity: Activity?) {
                mCurActivity = activity
            }

            override fun onActivityCreated(activity: Activity?, savedInstanceState: Bundle?) {
                mCurActivity = activity
            }

            override fun onActivityDestroyed(activity: Activity?) {
                mCurActivity = null
            }
        })
    }
}

abstract class DefaultActivityLifecycleCallbacks : Application.ActivityLifecycleCallbacks {
    override fun onActivityPaused(activity: Activity?) {
    }

    override fun onActivityResumed(activity: Activity?) {
    }

    override fun onActivityStarted(activity: Activity?) {
    }

    override fun onActivityDestroyed(activity: Activity?) {
    }

    override fun onActivitySaveInstanceState(activity: Activity?, outState: Bundle?) {
    }

    override fun onActivityStopped(activity: Activity?) {
    }

    override fun onActivityCreated(activity: Activity?, savedInstanceState: Bundle?) {
    }
}