package com.yy.mobile.miapi

import android.content.Context
import com.yy.mobile.baseapi.YY2UnionShareAction

/**
 * Created by 张宇 on 2018/10/25.
 * E-mail: zhangyu4@yy.com
 * YY: 909017428
 */
interface YY2MIShareAction : YY2UnionShareAction {

    /**
     * 调用小米直播的分享弹窗，并分享指定的内容。
     *
     * @param info 需要分享的内容
     * @param callback 可选，分享后的回调。接受部分平台没有回调。
     */
    override fun showShareDialog(context: Context, info: YYShareInfo, callback: YYShareCallback?)
}

data class YYShareInfo(
    /**
     * 分享标题
     */
    val title: String,
    /**
     * 分享内容
     */
    val text: String,
    /**
     * 可选，分享出去后点击的超链接，好像只有新浪微博支持带超链接？
     */
    val url: String? = null,
    /**
     * 可选，分享一个存在本地路径的图片
     */
    val imgPath: String? = null,
    /**
     * 直播间顶级频道号
     */
    val sid: Long = 0,
    /**
     * 直播间子频道号
     */
    val ssid: Long = 0,
    /**
     * 主播uid
     */
    val anchorUid: Long = 0

)

interface YYShareCallback {

    /**
     * 分享成功后通知给YY
     */
    fun onSuccess() {}

    /**
     * 取消分享后通知给YY
     */
    fun onCancel() {}

    /**
     * 分享失败后通知给YY
     */
    fun onFail() {}
}