package com.yy.mobile.miapi

import android.content.Context
import com.yy.mobile.baseapi.YY2UnionRechargeAction
import com.yy.mobile.baseapi.YYRechargeCallBack

/**
 * YY充值接口
 * Created by weidong_wu on 2018/10/19.
 */

interface YY2MIRechargeAction : YY2UnionRechargeAction {
    /**
     *
     * 无参充值弹窗接口
     */
    override fun showRechargeDialog(context: Context)

    /**
     * 有参充值弹窗接口
     * @param rechargeNum 充值金额
     */
    override fun showRechargeDialog(context: Context, rechargeNum: Int)

    /**
     *
     * 无参带回调充值弹窗接口
     *
     */
    override fun showRechargeDialog(context: Context, callBack: YYRechargeCallBack)

    /**
     * 有参带回调充值弹窗接口
     * @param rechargeNum 充值金额
     */
    override fun showRechargeDialog(context: Context, rechargeNum: Int, callBack: YYRechargeCallBack)
}