package com.yy.mobile.miapi

import com.yy.mobile.baseapi.Union2YYAuthAction
import org.jetbrains.annotations.TestOnly

/**
 * YY登陆接口，由YY实现，小米调用。
 */
interface MI2YYAuthAction : Union2YYAuthAction {

    /**
     * 授权登陆
     * 用户没有登陆任何账号时调用。调用该接口会调起手机YY第三方登陆的界面，登陆成功后，
     * 用户是YY用户，并返回 yyUid 和 ticket。
     * 小米利用 yyUid 和 ticket 创建小米账号并登陆。
     *
     * @param callback 登陆结果回调
     */
    fun authorizedLogin(callback: AuthCallback)

    /**
     * 小米账号绑定YY账号登陆
     * 用户已经登陆小米账号时调用。用户是小米用户，具有 zbid 和 accesstoken。
     * YY 利用 zbid 和 accesstoken 创建YY账号并登陆。
     * 登陆成功后，用户既是YY用户也是小米用户，并返回 yyUid 和 ticket。
     * 小米利用 yyUid 和 ticket 对YY账号和小米账号进行绑定。
     *
     * @param zbId 小米直播用户id
     * @param accessToken 小米授权凭证，数据类型在实现时可能会调整
     * @param callback 登陆结果回调
     */
    fun bindLogin(zbId: Long, accessToken: String, callback: AuthCallback)

    /**
     * 账号密码登录
     * @param user 通行证、YY号、邮箱、手机号之一
     * @param password 未加密的密码
     */
    @TestOnly
    fun login(user: String, password: String, callback: AuthCallback)
}
