package com.yy.mobile.init

import java.util.concurrent.CopyOnWriteArrayList

/**
 * Created by wangfeihang on 2019/3/27.
 */
object BasePluginInit {
    var initializeStage = BaseInitState.WAITING
        set(value) {
            field = value
            callbacks.forEach { it.onInitStateChanged(value) }
        }

    private var callbacks: CopyOnWriteArrayList<BasePluginInitCallBack> = CopyOnWriteArrayList()

    fun registerInitializeCallback(callback: BasePluginInitCallBack) {
        callbacks.add(callback)
        callback.onInitStateChanged(initializeStage)
    }

    interface BasePluginInitCallBack {
        fun onInitStateChanged(initializeStage: BaseInitState)
    }

    enum class BaseInitState {
        SUC,
        FAIL,
        INITIALIZING,
        WAITING
    }
}