package com.yy.mobile.baseapi

import android.content.Context

interface YY2UnionRechargeAction {
    /**
     *
     * 无参充值弹窗接口
     */
    fun showRechargeDialog(context: Context)

    /**
     * 有参充值弹窗接口
     * @param rechargeNum 充值金额
     */
    fun showRechargeDialog(context: Context, rechargeNum: Int)

    /**
     *
     * 无参带回调充值弹窗接口
     *
     */
    fun showRechargeDialog(context: Context, callBack: YYRechargeCallBack)

    /**
     * 有参带回调充值弹窗接口
     * @param rechargeNum 充值金额
     */
    fun showRechargeDialog(context: Context, rechargeNum: Int, callBack: YYRechargeCallBack)
}

interface YYRechargeCallBack {

    /**
     * 充值结果
     * @param result 返回结果
     */
    fun onRechargeResult(result: Boolean)
}

interface YY2OPQueryBalanceCallBack {

    /**
     * @param resultCode 0 查询成功
     * @param balance 用户余额
     */
    fun onResult(resultCode: Int, balance: Long)

}