package com.yy.mobile.util

import android.app.ActivityManager
import android.content.Context

/**
 * Created by wangfeihang on 2019/3/28.
 */

fun Context.getCurProcessName(): String? {
    var currentPid = android.os.Process.myPid()
    var mActivityManager = this.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager
    return mActivityManager.runningAppProcesses.firstOrNull {
        it.pid == currentPid
    }?.processName
}