package com.yy.mobile.laotie.api

import com.yy.mobile.baseapi.Union2YYAuthAction

/**
 * YY登陆接口，由YY实现，合作方(如老铁)调用。
 */
interface Laotie2YYAuthAction : Union2YYAuthAction {

    /**
     * Access Code登陆
     * 登陆成功后，用户是YY用户，并返回 yyUid 和 ticket。
     * 合作方可利用 yyUid 和 ticket 创建己方账号并登陆。
     *
     * @param code accessCode
     * @param callback 登陆结果回调
     */
    fun login(code: String, callback: AuthCallback)

    fun creditLogin(callback: AuthCallback)

    /**
     * Access Code登陆
     * 登陆成功后，用户是YY用户，并返回 yyUid 和 ticket。
     * 合作方可利用 yyUid 和 ticket 创建己方账号并登陆。
     *
     * @param code accessCode
     * @param callback 登陆结果回调
     */
    fun login(openId: String, accessToken: String, callback: AuthCallback)
}
