package com.yy.mobile.baseapi

import android.app.Activity

/**
 * Created by 张宇 on 2019-06-18.
 * E-mail: zhangyu4@yy.com
 * YY: 909017428
 */
interface Union2YYChannelIntent {

    /**
     * 构造进频道所需要的参数，必须有频道号
     * @param sid 顶级频道号
     * @param ssid 次级频道号
     */
    fun instance(sid: Long, ssid: Long): ChannelIntentBuilder

    interface ChannelIntentBuilder {

        /**
         * 可选，模版id
         */
        fun templateId(templateId: String): ChannelIntentBuilder

        /**
         * 可选，模版id
         */
        fun templateId(templateId: Long): ChannelIntentBuilder

        /**
         * 可选，推荐算法参数
         */
        fun token(token: String): ChannelIntentBuilder

        /**
         * 可选，推荐算法参数
         */
        fun recommend(recommend: Int): ChannelIntentBuilder

        /**
         * 可选，主播uid
         */
        fun anchorUid(uid: Long): ChannelIntentBuilder

        /**
         * 可选，开播封面
         */
        fun thumb(screenShotUrl: String): ChannelIntentBuilder

        /**
         * 进频道跳转
         */
        fun joinChannel(activity: Activity?)
    }
}