/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.creategiftpk.ui;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.yy.mobile.creategiftpk.ui.NoDataSmallFragment;
import com.yy.mobile.ui.common.LoadingFragment;
import com.yy.mobile.ui.common.NetworkErrorFragment;
import com.yy.mobile.ui.common.NoDataFragmentWithBtn;
import com.yy.mobile.ui.common.ReloadFragment;
import com.yy.mobile.util.log.MLog;

public class StateLayout
extends FrameLayout {
    private String statusTAG;
    private FragmentManager fragmentManager;
    private View.OnClickListener loadListener;

    public StateLayout(@NonNull Context context) {
        super(context);
    }

    public StateLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int id2 = this.getId() == 0 ? ((Object)((Object)this)).hashCode() : this.getId();
        this.statusTAG = String.valueOf(id2);
    }

    public void setFragmentManager(FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
    }

    public void setLoadListener(View.OnClickListener onClickListener) {
        this.loadListener = onClickListener;
    }

    protected View.OnClickListener getLoadListener() {
        return this.loadListener;
    }

    public void showLoading() {
        this.showLoading(0, 0);
    }

    public void showLoading(int drawable2, int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.fragmentManager == null) {
            return;
        }
        if (this.getId() <= 0) {
            return;
        }
        LoadingFragment fragment = LoadingFragment.newInstance((int)drawable2, (int)tips);
        this.fragmentManager.beginTransaction().replace(this.getId(), (Fragment)fragment, this.statusTAG).commitAllowingStateLoss();
    }

    public void showReload() {
        this.showReload(0, 0);
    }

    public void showReload(int drawable2, int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.fragmentManager == null) {
            return;
        }
        if (this.getId() <= 0) {
            MLog.error((Object)"StateLayout", (String)"ly, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        ReloadFragment fragment = ReloadFragment.newInstance((int)drawable2, (int)tips);
        fragment.setListener(this.getLoadListener());
        this.fragmentManager.beginTransaction().replace(this.getId(), (Fragment)fragment, this.statusTAG).commitAllowingStateLoss();
    }

    public void showNoData() {
        this.showNoData(0, 0);
    }

    public void showNoData(int drawable2, int tips) {
        if (tips <= 0) {
            this.showNoData(drawable2, "");
        } else {
            this.showNoData(drawable2, this.getResources().getString(tips));
        }
    }

    public void showNoData(int drawable2, CharSequence charSequence) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.fragmentManager == null) {
            return;
        }
        if (this.getId() <= 0) {
            MLog.error((Object)"StateLayout", (String)"ly, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoDataSmallFragment fragment = NoDataSmallFragment.newInstance(drawable2, charSequence);
        fragment.setListener(this.getLoadListener());
        this.fragmentManager.beginTransaction().replace(this.getId(), (Fragment)fragment, this.statusTAG).commitAllowingStateLoss();
    }

    public void showNoDataWithBtn(int drawable2, String tips, String btnText, View.OnClickListener btnClickListener) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.fragmentManager == null) {
            return;
        }
        if (this.getId() <= 0) {
            MLog.error((Object)"StateLayout", (String)"had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoDataFragmentWithBtn fragment = NoDataFragmentWithBtn.newInstance((int)drawable2, (CharSequence)tips);
        fragment.setBtnContent(btnText, btnClickListener);
        this.fragmentManager.beginTransaction().replace(this.getId(), (Fragment)fragment, this.statusTAG).commitAllowingStateLoss();
    }

    public void showNetworkErr() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.fragmentManager == null) {
            return;
        }
        if (this.getId() <= 0) {
            MLog.error((Object)"StateLayout", (String)"ly, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NetworkErrorFragment fragment = NetworkErrorFragment.newInstance();
        fragment.setListener(this.getLoadListener());
        this.fragmentManager.beginTransaction().replace(this.getId(), (Fragment)fragment, this.statusTAG).commitAllowingStateLoss();
    }

    public void hideStatus() {
        if (this.fragmentManager == null) {
            return;
        }
        Fragment fragment = this.fragmentManager.findFragmentByTag(this.statusTAG);
        if (fragment != null) {
            this.fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
        } else if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)"StateLayout", (String)"ly, status fragment is NULL", (Object[])new Object[0]);
        }
    }

    @TargetApi(value=17)
    protected boolean checkActivityValid() {
        if (this.getContext() == null) {
            return false;
        }
        if (this.getContext() instanceof Activity) {
            if (((Activity)this.getContext()).isFinishing()) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 17 && ((Activity)this.getContext()).isDestroyed()) {
                return false;
            }
        }
        return true;
    }
}

