/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.creategiftpk.diffutil;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.RecyclerView;
import com.yy.mobile.creategiftpk.diffutil.BatchingListUpdateCallback;
import com.yy.mobile.creategiftpk.diffutil.ListUpdateCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DiffUtil {
    private static final Comparator<Snake> SNAKE_COMPARATOR = new Comparator<Snake>(){

        @Override
        public int compare(Snake o1, Snake o2) {
            int cmpX = o1.x - o2.x;
            return cmpX == 0 ? o1.y - o2.y : cmpX;
        }
    };

    private DiffUtil() {
    }

    public static DiffResult calculateDiff(Callback cb) {
        return DiffUtil.calculateDiff(cb, true);
    }

    public static DiffResult calculateDiff(Callback cb, boolean detectMoves) {
        int oldSize = cb.getOldListSize();
        int newSize = cb.getNewListSize();
        ArrayList<Snake> snakes = new ArrayList<Snake>();
        ArrayList<Range> stack = new ArrayList<Range>();
        stack.add(new Range(0, oldSize, 0, newSize));
        int max = oldSize + newSize + Math.abs(oldSize - newSize);
        int[] forward = new int[max * 2];
        int[] backward = new int[max * 2];
        ArrayList<Range> rangePool = new ArrayList<Range>();
        while (!stack.isEmpty()) {
            Range range = (Range)stack.remove(stack.size() - 1);
            Snake snake = DiffUtil.diffPartial(cb, range.oldListStart, range.oldListEnd, range.newListStart, range.newListEnd, forward, backward, max);
            if (snake != null) {
                if (snake.size > 0) {
                    snakes.add(snake);
                }
                snake.x += range.oldListStart;
                snake.y += range.newListStart;
                Range left = rangePool.isEmpty() ? new Range() : (Range)rangePool.remove(rangePool.size() - 1);
                left.oldListStart = range.oldListStart;
                left.newListStart = range.newListStart;
                if (snake.reverse) {
                    left.oldListEnd = snake.x;
                    left.newListEnd = snake.y;
                } else if (snake.removal) {
                    left.oldListEnd = snake.x - 1;
                    left.newListEnd = snake.y;
                } else {
                    left.oldListEnd = snake.x;
                    left.newListEnd = snake.y - 1;
                }
                stack.add(left);
                Range right = range;
                if (snake.reverse) {
                    if (snake.removal) {
                        right.oldListStart = snake.x + snake.size + 1;
                        right.newListStart = snake.y + snake.size;
                    } else {
                        right.oldListStart = snake.x + snake.size;
                        right.newListStart = snake.y + snake.size + 1;
                    }
                } else {
                    right.oldListStart = snake.x + snake.size;
                    right.newListStart = snake.y + snake.size;
                }
                stack.add(right);
                continue;
            }
            rangePool.add(range);
        }
        Collections.sort(snakes, SNAKE_COMPARATOR);
        return new DiffResult(cb, snakes, forward, backward, detectMoves);
    }

    private static Snake diffPartial(Callback cb, int startOld, int endOld, int startNew, int endNew, int[] forward, int[] backward, int kOffset) {
        int oldSize = endOld - startOld;
        int newSize = endNew - startNew;
        if (endOld - startOld < 1 || endNew - startNew < 1) {
            return null;
        }
        int delta = oldSize - newSize;
        int dLimit = (oldSize + newSize + 1) / 2;
        Arrays.fill(forward, kOffset - dLimit - 1, kOffset + dLimit + 1, 0);
        Arrays.fill(backward, kOffset - dLimit - 1 + delta, kOffset + dLimit + 1 + delta, oldSize);
        boolean checkInFwd = delta % 2 != 0;
        for (int d = 0; d <= dLimit; ++d) {
            int k;
            for (k = -d; k <= d; k += 2) {
                boolean removal;
                int x;
                if (k == -d || k != d && forward[kOffset + k - 1] < forward[kOffset + k + 1]) {
                    x = forward[kOffset + k + 1];
                    removal = false;
                } else {
                    x = forward[kOffset + k - 1] + 1;
                    removal = true;
                }
                for (int y = x - k; x < oldSize && y < newSize && cb.areItemsTheSame(startOld + x, startNew + y); ++x, ++y) {
                }
                forward[kOffset + k] = x;
                if (!checkInFwd || k < delta - d + 1 || k > delta + d - 1 || forward[kOffset + k] < backward[kOffset + k]) continue;
                Snake outSnake = new Snake();
                outSnake.x = backward[kOffset + k];
                outSnake.y = outSnake.x - k;
                outSnake.size = forward[kOffset + k] - backward[kOffset + k];
                outSnake.removal = removal;
                outSnake.reverse = false;
                return outSnake;
            }
            for (k = -d; k <= d; k += 2) {
                boolean removal;
                int x;
                int backwardK = k + delta;
                if (backwardK == d + delta || backwardK != -d + delta && backward[kOffset + backwardK - 1] < backward[kOffset + backwardK + 1]) {
                    x = backward[kOffset + backwardK - 1];
                    removal = false;
                } else {
                    x = backward[kOffset + backwardK + 1] - 1;
                    removal = true;
                }
                for (int y = x - backwardK; x > 0 && y > 0 && cb.areItemsTheSame(startOld + x - 1, startNew + y - 1); --x, --y) {
                }
                backward[kOffset + backwardK] = x;
                if (checkInFwd || k + delta < -d || k + delta > d || forward[kOffset + backwardK] < backward[kOffset + backwardK]) continue;
                Snake outSnake = new Snake();
                outSnake.x = backward[kOffset + backwardK];
                outSnake.y = outSnake.x - backwardK;
                outSnake.size = forward[kOffset + backwardK] - backward[kOffset + backwardK];
                outSnake.removal = removal;
                outSnake.reverse = true;
                return outSnake;
            }
        }
        throw new IllegalStateException("DiffUtil hit an unexpected case while trying to calculate the optimal path. Please make sure your data is not changing during the diff calculation.");
    }

    private static class PostponedUpdate {
        int posInOwnerList;
        int currentPos;
        boolean removal;

        public PostponedUpdate(int posInOwnerList, int currentPos, boolean removal) {
            this.posInOwnerList = posInOwnerList;
            this.currentPos = currentPos;
            this.removal = removal;
        }
    }

    public static class DiffResult {
        private final List<Snake> mSnakes;
        private final int[] mOldItemStatuses;
        private final int[] mNewItemStatuses;
        private final Callback mCallback;
        private final int mOldListSize;
        private final int mNewListSize;
        private final boolean mDetectMoves;

        DiffResult(Callback callback, List<Snake> snakes, int[] oldItemStatuses, int[] newItemStatuses, boolean detectMoves) {
            this.mSnakes = snakes;
            this.mOldItemStatuses = oldItemStatuses;
            this.mNewItemStatuses = newItemStatuses;
            Arrays.fill(this.mOldItemStatuses, 0);
            Arrays.fill(this.mNewItemStatuses, 0);
            this.mCallback = callback;
            this.mOldListSize = callback.getOldListSize();
            this.mNewListSize = callback.getNewListSize();
            this.mDetectMoves = detectMoves;
            this.addRootSnake();
            this.findMatchingItems();
        }

        private void addRootSnake() {
            Snake firstSnake;
            Snake snake = firstSnake = this.mSnakes.isEmpty() ? null : this.mSnakes.get(0);
            if (firstSnake == null || firstSnake.x != 0 || firstSnake.y != 0) {
                Snake root = new Snake();
                root.x = 0;
                root.y = 0;
                root.removal = false;
                root.size = 0;
                root.reverse = false;
                this.mSnakes.add(0, root);
            }
        }

        private void findMatchingItems() {
            int posOld = this.mOldListSize;
            int posNew = this.mNewListSize;
            for (int i = this.mSnakes.size() - 1; i >= 0; --i) {
                Snake snake = this.mSnakes.get(i);
                int endX = snake.x + snake.size;
                int endY = snake.y + snake.size;
                if (this.mDetectMoves) {
                    while (posOld > endX) {
                        this.findAddition(posOld, posNew, i);
                        --posOld;
                    }
                    while (posNew > endY) {
                        this.findRemoval(posOld, posNew, i);
                        --posNew;
                    }
                }
                for (int j = 0; j < snake.size; ++j) {
                    int oldItemPos = snake.x + j;
                    int newItemPos = snake.y + j;
                    boolean theSame = this.mCallback.areContentsTheSame(oldItemPos, newItemPos);
                    int changeFlag = theSame ? 1 : 2;
                    this.mOldItemStatuses[oldItemPos] = newItemPos << 5 | changeFlag;
                    this.mNewItemStatuses[newItemPos] = oldItemPos << 5 | changeFlag;
                }
                posOld = snake.x;
                posNew = snake.y;
            }
        }

        private void findAddition(int x, int y, int snakeIndex) {
            if (this.mOldItemStatuses[x - 1] != 0) {
                return;
            }
            this.findMatchingItem(x, y, snakeIndex, false);
        }

        private void findRemoval(int x, int y, int snakeIndex) {
            if (this.mNewItemStatuses[y - 1] != 0) {
                return;
            }
            this.findMatchingItem(x, y, snakeIndex, true);
        }

        private boolean findMatchingItem(int x, int y, int snakeIndex, boolean removal) {
            int curY;
            int curX;
            int myItemPos;
            if (removal) {
                myItemPos = y - 1;
                curX = x;
                curY = y - 1;
            } else {
                myItemPos = x - 1;
                curX = x - 1;
                curY = y;
            }
            for (int i = snakeIndex; i >= 0; --i) {
                int pos;
                Snake snake = this.mSnakes.get(i);
                int endX = snake.x + snake.size;
                int endY = snake.y + snake.size;
                if (removal) {
                    for (pos = curX - 1; pos >= endX; --pos) {
                        if (!this.mCallback.areItemsTheSame(pos, myItemPos)) continue;
                        boolean theSame = this.mCallback.areContentsTheSame(pos, myItemPos);
                        int changeFlag = theSame ? 8 : 4;
                        this.mNewItemStatuses[myItemPos] = pos << 5 | 0x10;
                        this.mOldItemStatuses[pos] = myItemPos << 5 | changeFlag;
                        return true;
                    }
                } else {
                    for (pos = curY - 1; pos >= endY; --pos) {
                        if (!this.mCallback.areItemsTheSame(myItemPos, pos)) continue;
                        boolean theSame = this.mCallback.areContentsTheSame(myItemPos, pos);
                        int changeFlag = theSame ? 8 : 4;
                        this.mOldItemStatuses[x - 1] = pos << 5 | 0x10;
                        this.mNewItemStatuses[pos] = x - 1 << 5 | changeFlag;
                        return true;
                    }
                }
                curX = snake.x;
                curY = snake.y;
            }
            return false;
        }

        public void dispatchUpdatesTo(final RecyclerView.Adapter adapter) {
            this.dispatchUpdatesTo(new ListUpdateCallback(){

                @Override
                public void onInserted(int position, int count) {
                    adapter.notifyItemRangeInserted(position, count);
                }

                @Override
                public void onRemoved(int position, int count) {
                    adapter.notifyItemRangeRemoved(position, count);
                }

                @Override
                public void onMoved(int fromPosition, int toPosition) {
                    adapter.notifyItemMoved(fromPosition, toPosition);
                }

                @Override
                public void onChanged(int position, int count, Object payload) {
                    adapter.notifyItemRangeChanged(position, count, payload);
                }
            });
        }

        public void dispatchUpdatesTo(ListUpdateCallback updateCallback) {
            BatchingListUpdateCallback batchingCallback;
            if (updateCallback instanceof BatchingListUpdateCallback) {
                batchingCallback = (BatchingListUpdateCallback)updateCallback;
            } else {
                batchingCallback = new BatchingListUpdateCallback(updateCallback);
                updateCallback = batchingCallback;
            }
            ArrayList<PostponedUpdate> postponedUpdates = new ArrayList<PostponedUpdate>();
            int posOld = this.mOldListSize;
            int posNew = this.mNewListSize;
            for (int snakeIndex = this.mSnakes.size() - 1; snakeIndex >= 0; --snakeIndex) {
                Snake snake = this.mSnakes.get(snakeIndex);
                int snakeSize = snake.size;
                int endX = snake.x + snakeSize;
                int endY = snake.y + snakeSize;
                if (endX < posOld) {
                    this.dispatchRemovals(postponedUpdates, batchingCallback, endX, posOld - endX, endX);
                }
                if (endY < posNew) {
                    this.dispatchAdditions(postponedUpdates, batchingCallback, endX, posNew - endY, endY);
                }
                for (int i = snakeSize - 1; i >= 0; --i) {
                    if ((this.mOldItemStatuses[snake.x + i] & 0x1F) != 2) continue;
                    batchingCallback.onChanged(snake.x + i, 1, this.mCallback.getChangePayload(snake.x + i, snake.y + i));
                }
                posOld = snake.x;
                posNew = snake.y;
            }
            batchingCallback.dispatchLastEvent();
        }

        private static PostponedUpdate removePostponedUpdate(List<PostponedUpdate> updates, int pos, boolean removal) {
            for (int i = updates.size() - 1; i >= 0; --i) {
                PostponedUpdate update = updates.get(i);
                if (update.posInOwnerList != pos || update.removal != removal) continue;
                updates.remove(i);
                for (int j = i; j < updates.size(); ++j) {
                    updates.get((int)j).currentPos = updates.get((int)j).currentPos + (removal ? 1 : -1);
                }
                return update;
            }
            return null;
        }

        private void dispatchAdditions(List<PostponedUpdate> postponedUpdates, ListUpdateCallback updateCallback, int start, int count, int globalIndex) {
            if (!this.mDetectMoves) {
                updateCallback.onInserted(start, count);
                return;
            }
            block5: for (int i = count - 1; i >= 0; --i) {
                int status = this.mNewItemStatuses[globalIndex + i] & 0x1F;
                switch (status) {
                    case 0: {
                        updateCallback.onInserted(start, 1);
                        for (PostponedUpdate update : postponedUpdates) {
                            ++update.currentPos;
                        }
                        continue block5;
                    }
                    case 4: 
                    case 8: {
                        PostponedUpdate update;
                        int pos = this.mNewItemStatuses[globalIndex + i] >> 5;
                        update = DiffResult.removePostponedUpdate(postponedUpdates, pos, true);
                        updateCallback.onMoved(update.currentPos, start);
                        if (status != 4) continue block5;
                        updateCallback.onChanged(start, 1, this.mCallback.getChangePayload(pos, globalIndex + i));
                        continue block5;
                    }
                    case 16: {
                        postponedUpdates.add(new PostponedUpdate(globalIndex + i, start, false));
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("unknown flag for pos " + (globalIndex + i) + " " + Long.toBinaryString(status));
                    }
                }
            }
        }

        private void dispatchRemovals(List<PostponedUpdate> postponedUpdates, ListUpdateCallback updateCallback, int start, int count, int globalIndex) {
            if (!this.mDetectMoves) {
                updateCallback.onRemoved(start, count);
                return;
            }
            block5: for (int i = count - 1; i >= 0; --i) {
                int status = this.mOldItemStatuses[globalIndex + i] & 0x1F;
                switch (status) {
                    case 0: {
                        updateCallback.onRemoved(start + i, 1);
                        for (PostponedUpdate update : postponedUpdates) {
                            --update.currentPos;
                        }
                        continue block5;
                    }
                    case 4: 
                    case 8: {
                        PostponedUpdate update;
                        int pos = this.mOldItemStatuses[globalIndex + i] >> 5;
                        update = DiffResult.removePostponedUpdate(postponedUpdates, pos, false);
                        updateCallback.onMoved(start + i, update.currentPos - 1);
                        if (status != 4) continue block5;
                        updateCallback.onChanged(update.currentPos - 1, 1, this.mCallback.getChangePayload(globalIndex + i, pos));
                        continue block5;
                    }
                    case 16: {
                        postponedUpdates.add(new PostponedUpdate(globalIndex + i, start + i, true));
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("unknown flag for pos " + (globalIndex + i) + " " + Long.toBinaryString(status));
                    }
                }
            }
        }

        @VisibleForTesting
        List<Snake> getSnakes() {
            return this.mSnakes;
        }
    }

    static class Range {
        int oldListStart;
        int oldListEnd;
        int newListStart;
        int newListEnd;

        public Range() {
        }

        public Range(int oldListStart, int oldListEnd, int newListStart, int newListEnd) {
            this.oldListStart = oldListStart;
            this.oldListEnd = oldListEnd;
            this.newListStart = newListStart;
            this.newListEnd = newListEnd;
        }
    }

    static class Snake {
        int x;
        int y;
        int size;
        boolean removal;
        boolean reverse;

        Snake() {
        }
    }

    public static abstract class Callback {
        public abstract int getOldListSize();

        public abstract int getNewListSize();

        public abstract boolean areItemsTheSame(int var1, int var2);

        public abstract boolean areContentsTheSame(int var1, int var2);

        @Nullable
        public Object getChangePayload(int oldItemPosition, int newItemPosition) {
            return null;
        }
    }
}

