/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.creategiftpk.ui.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.trello.rxlifecycle2.LifecycleTransformer;
import com.yy.mobile.creategiftpk.R;
import com.yy.mobile.creategiftpk.core.IGiftPkCore;
import com.yy.mobile.creategiftpk.diffutil.DiffUtil;
import com.yy.mobile.creategiftpk.ui.adapter.RecycleViewAdapterCompat;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.liveapi.mic.IMicApi;
import com.yy.mobile.ui.home.BasicFaceHelper;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.AdminInfo;
import com.yymobile.core.channel.micinfo.MicTopInfo;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MicListAdapter
extends RecycleViewAdapterCompat<MicTopInfoEx> {
    private static final String TAG = "MicListAdapter";
    Activity mContext;
    RecyclerView mRv;
    public List<MicTopInfoEx> mMicList = new ArrayList<MicTopInfoEx>();
    private HashMap<Long, AdminInfo> mAdminInfoList = new HashMap();
    public int mSelectedPos = -1;
    LifecycleTransformer<DiffUtil.DiffResult> transformer;
    public int team;

    public void setTeam(int team) {
        this.team = team;
    }

    public void setRv(RecyclerView mRv) {
        this.mRv = mRv;
    }

    public MicListAdapter(Activity context, LifecycleTransformer<DiffUtil.DiffResult> transformer) {
        this.mContext = context;
        this.transformer = transformer;
    }

    public List<MicTopInfoEx> getMicList() {
        return this.mMicList;
    }

    public void upadteMicList(List<MicTopInfo> micList) {
        if (micList == null || micList.size() == 0) {
            this.mMicList.clear();
            this.notifyDataSetChanged();
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        Map<Long, UserInfo> userInfoMap = this.getUserInfoMap();
        final ArrayList<MicTopInfoEx> newData = new ArrayList<MicTopInfoEx>();
        MicTopInfoEx exBlue = ((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).getSelectTeamBlue();
        MicTopInfoEx exYellow = ((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).getSelectTeamYellow();
        for (int i = 0; i < micList.size(); ++i) {
            MicTopInfo info = micList.get(i);
            MicTopInfoEx ex = MicTopInfoEx.build(info);
            if (exBlue != null && exBlue.uid == ex.uid) {
                if (this.team == 0) {
                    ex.teamType = Team_type.is_leader;
                    this.mSelectedPos = i;
                } else {
                    ex.teamType = Team_type.is_other_leader;
                }
            } else if (exYellow != null && exYellow.uid == ex.uid) {
                if (this.team == 1) {
                    ex.teamType = Team_type.is_leader;
                    this.mSelectedPos = i;
                } else {
                    ex.teamType = Team_type.is_other_leader;
                }
            }
            newData.add(ex);
            this.mAdminInfoList.put(micList.get((int)i).uid, ICoreManagerBase.getChannelLinkCore().getChannelAdminRoles(micList.get((int)i).uid));
            if (userInfoMap != null && !userInfoMap.containsKey(micList.get((int)i).uid)) {
                UserInfo userInfo = ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).getCacheUserInfoByUid(micList.get((int)i).uid);
                if (userInfo != null) {
                    userInfoMap.put(micList.get((int)i).uid, userInfo);
                } else {
                    idList.add(micList.get((int)i).uid);
                }
            }
            if (userInfoMap == null || userInfoMap.get(ex.uid) == null) continue;
            if (!StringUtils.isEmpty((String)userInfoMap.get((Object)Long.valueOf((long)ex.uid)).iconUrl_100_100).booleanValue()) {
                ex.portraitUrl = userInfoMap.get((Object)Long.valueOf((long)ex.uid)).iconUrl_100_100;
            }
            if (!StringUtils.isEmpty((String)userInfoMap.get((Object)Long.valueOf((long)ex.uid)).iconUrl).booleanValue()) {
                ex.portraitUrl = userInfoMap.get((Object)Long.valueOf((long)ex.uid)).iconUrl;
            }
            if (!StringUtils.isEmpty((String)userInfoMap.get((Object)Long.valueOf((long)ex.uid)).iconUrl_144_144).booleanValue()) {
                ex.portraitUrl = userInfoMap.get((Object)Long.valueOf((long)ex.uid)).iconUrl_144_144;
            }
            if (StringUtils.isEmpty((String)userInfoMap.get((Object)Long.valueOf((long)ex.uid)).nickName).booleanValue()) continue;
            ex.name = userInfoMap.get((Object)Long.valueOf((long)ex.uid)).nickName;
        }
        ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).requestBasicUserInfo(idList, true);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("upadteMicList  micList.size() = " + micList.size()), (Object[])new Object[0]);
        }
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<DiffUtil.DiffResult>(){

            public void subscribe(@NonNull ObservableEmitter<DiffUtil.DiffResult> e) {
                try {
                    DiffUtil.DiffResult diff = DiffUtil.calculateDiff(new DiffCallBack(MicListAdapter.this.mMicList, newData), true);
                    e.onNext((Object)diff);
                }
                catch (Exception ex) {
                    MLog.error((Object)MicListAdapter.TAG, (Throwable)ex);
                }
            }
        }).subscribeOn(Schedulers.computation()).compose(this.transformer).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<DiffUtil.DiffResult>(){

            public void accept(@NonNull DiffUtil.DiffResult diffResult) {
                try {
                    diffResult.dispatchUpdatesTo(MicListAdapter.this);
                    if (MicListAdapter.this.mSelectedPos > 0) {
                        MicListAdapter.this.mRv.scrollToPosition(MicListAdapter.this.mSelectedPos);
                    }
                    MicListAdapter.this.mMicList.clear();
                    MicListAdapter.this.mMicList.addAll(newData);
                }
                catch (Exception ex) {
                    MLog.error((Object)MicListAdapter.TAG, (Throwable)ex);
                }
            }
        });
    }

    @Override
    public int getItemCount() {
        return this.mMicList.size();
    }

    @Override
    public MicTopInfoEx getItem(int position) {
        if (position < this.getItemCount() && position >= 0) {
            return this.mMicList.get(position);
        }
        return null;
    }

    @Override
    public View onCreateView(ViewGroup viewGroup, int viewType) {
        return LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_mic_item, viewGroup, false);
    }

    @Override
    public void onBindViewHolder(final RecycleViewAdapterCompat.ViewHolder viewHolder, int position) {
        final MicTopInfoEx micTopInfo = this.getItem(position);
        if (micTopInfo == null) {
            return;
        }
        TextView tvTitleMark = (TextView)viewHolder.get(R.id.tv_title_mark);
        tvTitleMark.setText((CharSequence)String.valueOf(position + 1));
        RecycleImageView ivPortrait = (RecycleImageView)viewHolder.get(R.id.iv_portrait);
        if (this.getUserInfoMap() != null) {
            UserInfo userInfo = this.getUserInfoMap().get(micTopInfo.uid);
            if (userInfo != null && !TextUtils.isEmpty((CharSequence)userInfo.iconUrl_100_100)) {
                BasicFaceHelper.loadFace((String)userInfo.iconUrl_100_100, (int)userInfo.iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)ivPortrait, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
            } else if (!(userInfo == null || TextUtils.isEmpty((CharSequence)userInfo.iconUrl) && userInfo.iconIndex <= 0)) {
                BasicFaceHelper.loadFace((String)userInfo.iconUrl, (int)userInfo.iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)ivPortrait, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
            } else {
                ImageLoader.loadImage((RecycleImageView)ivPortrait, (String)micTopInfo.portraitUrl, (int)R.drawable.default_portrait);
            }
        }
        TextView tvNickName = (TextView)viewHolder.get(R.id.tv_nick_name);
        tvNickName.setText((CharSequence)"");
        if (!StringUtils.isEmpty((String)micTopInfo.name).booleanValue()) {
            if (micTopInfo.name.length() > 12) {
                tvNickName.setText((CharSequence)(micTopInfo.name.substring(0, 12) + "..."));
            } else {
                tvNickName.setText((CharSequence)micTopInfo.name);
            }
        }
        ImageView role = (ImageView)viewHolder.get(R.id.role);
        if (this.mAdminInfoList.containsKey(micTopInfo.uid)) {
            Drawable drawable2 = this.getModuleDrawable(micTopInfo.uid);
            if (drawable2 != null) {
                role.setVisibility(0);
                role.setImageDrawable(drawable2);
            } else {
                role.setVisibility(8);
            }
        } else {
            role.setVisibility(8);
        }
        final ImageView ivSelectedOtherTeam = (ImageView)viewHolder.get(R.id.iv_selected_other_team);
        final TextView tvSelectedTeam = (TextView)viewHolder.get(R.id.tv_selected_team);
        final TextView tvSetLeader = (TextView)viewHolder.get(R.id.tv_set_leader);
        if (micTopInfo.teamType == Team_type.is_leader) {
            ivSelectedOtherTeam.setVisibility(4);
            tvSelectedTeam.setVisibility(0);
            tvSetLeader.setVisibility(4);
        } else if (micTopInfo.teamType == Team_type.is_other_leader) {
            ivSelectedOtherTeam.setVisibility(0);
            if (this.team == 0) {
                ivSelectedOtherTeam.setImageResource(R.drawable.happypk_yellowleader);
            } else {
                ivSelectedOtherTeam.setImageResource(R.drawable.happypk_blueleader);
            }
            tvSelectedTeam.setVisibility(4);
            tvSetLeader.setVisibility(4);
        } else if (micTopInfo.teamType == Team_type.set_leader) {
            ivSelectedOtherTeam.setVisibility(4);
            tvSelectedTeam.setVisibility(4);
            tvSetLeader.setVisibility(0);
        }
        tvSetLeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MicListAdapter.this.mSelectedPos != -1) {
                    RecycleViewAdapterCompat.ViewHolder vh = (RecycleViewAdapterCompat.ViewHolder)MicListAdapter.this.mRv.findViewHolderForLayoutPosition(MicListAdapter.this.mSelectedPos);
                    if (vh != null) {
                        vh.get(R.id.iv_selected_other_team).setVisibility(4);
                        vh.get(R.id.tv_selected_team).setVisibility(4);
                        vh.get(R.id.tv_set_leader).setVisibility(0);
                    } else {
                        MicListAdapter.this.notifyItemChanged(MicListAdapter.this.mSelectedPos);
                    }
                    MicTopInfoEx ex = MicListAdapter.this.getItem(MicListAdapter.this.mSelectedPos);
                    ex.teamType = Team_type.set_leader;
                }
                MicListAdapter.this.mSelectedPos = viewHolder.getAdapterPosition();
                micTopInfo.teamType = Team_type.is_leader;
                ivSelectedOtherTeam.setVisibility(4);
                tvSelectedTeam.setVisibility(0);
                tvSetLeader.setVisibility(4);
                if (MicListAdapter.this.team == 0) {
                    ((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).saveSelectTeamBlue(micTopInfo.build());
                } else {
                    ((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).saveSelectTeamYellow(micTopInfo.build());
                }
            }
        });
    }

    private Map<Long, UserInfo> getUserInfoMap() {
        if (CoreApiManager.getInstance().containsApi(IMicApi.class)) {
            return ((IMicApi)CoreApiManager.getInstance().getApi(IMicApi.class)).getMicUserInfos();
        }
        return null;
    }

    private Drawable getModuleDrawable(long uid) {
        if (CoreApiManager.getInstance().containsApi(IMicApi.class)) {
            return ((IMicApi)CoreApiManager.getInstance().getApi(IMicApi.class)).getModuleDrawable(uid);
        }
        return null;
    }

    class DiffCallBack
    extends DiffUtil.Callback {
        List<MicTopInfoEx> mOldData;
        List<MicTopInfoEx> mNewData;

        public DiffCallBack(List<MicTopInfoEx> mOldData, List<MicTopInfoEx> mNewData) {
            this.mOldData = mOldData;
            this.mNewData = mNewData;
        }

        @Override
        public int getOldListSize() {
            return this.mOldData != null ? this.mOldData.size() : 0;
        }

        @Override
        public int getNewListSize() {
            return this.mNewData != null ? this.mNewData.size() : 0;
        }

        @Override
        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            return this.mOldData.get((int)oldItemPosition).uid == this.mNewData.get((int)newItemPosition).uid;
        }

        @Override
        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            MicTopInfoEx oldEx = this.mOldData.get(oldItemPosition);
            MicTopInfoEx newEx = this.mNewData.get(newItemPosition);
            if (oldEx.uid != newEx.uid) {
                return false;
            }
            if (oldEx.teamType != newEx.teamType) {
                return false;
            }
            if (oldEx.name == null && newEx.name != null) {
                return false;
            }
            if (oldEx.name != null && newEx.name == null) {
                return false;
            }
            if (oldEx.name != null && !oldEx.name.equals(newEx.name)) {
                return false;
            }
            if (oldEx.portraitUrl == null && newEx.portraitUrl != null) {
                return false;
            }
            if (oldEx.portraitUrl != null && newEx.portraitUrl == null) {
                return false;
            }
            if (oldEx.portraitUrl != null && !oldEx.portraitUrl.equals(newEx.portraitUrl)) {
                return false;
            }
            return oldEx.nobleLevel == newEx.nobleLevel;
        }
    }

    public static class MicTopInfoEx
    extends MicTopInfo {
        Team_type teamType;

        MicTopInfoEx build() {
            MicTopInfoEx ex = new MicTopInfoEx();
            ex.teamType = this.teamType;
            ex.name = this.name;
            ex.guardianLevel = this.guardianLevel;
            ex.isActualTimeName = this.isActualTimeName;
            ex.isAnchor = this.isAnchor;
            ex.ismultiMic = this.ismultiMic;
            ex.isSpeaking = this.isSpeaking;
            ex.isSubscribe = this.isSubscribe;
            ex.nobleLevel = this.nobleLevel;
            ex.portraitIndex = this.portraitIndex;
            ex.portraitUrl = this.portraitUrl;
            ex.showMenu = this.showMenu;
            ex.time = this.time;
            ex.uid = this.uid;
            return ex;
        }

        public static MicTopInfoEx build(MicTopInfo micTopInfo) {
            MicTopInfoEx ex = new MicTopInfoEx();
            ex.name = micTopInfo.name;
            ex.guardianLevel = micTopInfo.guardianLevel;
            ex.isActualTimeName = micTopInfo.isActualTimeName;
            ex.isAnchor = micTopInfo.isAnchor;
            ex.ismultiMic = micTopInfo.ismultiMic;
            ex.isSpeaking = micTopInfo.isSpeaking;
            ex.isSubscribe = micTopInfo.isSubscribe;
            ex.nobleLevel = micTopInfo.nobleLevel;
            ex.portraitIndex = micTopInfo.portraitIndex;
            ex.portraitUrl = micTopInfo.portraitUrl;
            ex.showMenu = micTopInfo.showMenu;
            ex.time = micTopInfo.time;
            ex.uid = micTopInfo.uid;
            ex.teamType = Team_type.set_leader;
            return ex;
        }

        public String toString() {
            return "MicTopInfoEx{team_type=" + (Object)((Object)this.teamType) + ",name=" + this.name + ",portraitUrl=" + this.portraitUrl + '}';
        }
    }

    public static enum Team_type {
        set_leader,
        is_leader,
        is_other_leader;

    }
}

